/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.plot.access;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositoryUpdatePolicy;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.plot.access.PlotPlayerAccess;
import com.equestricraft.core.plot.access.PlotPlayerAccessDatabase;
import com.equestricraft.core.plot.access.PlotPlayerAccessKey;
import java.util.List;
import java.util.Optional;

public class PlotPlayerAccessRepository
extends Repository<PlotPlayerAccess, PlotPlayerAccessKey> {
    @Service
    private PlotPlayerAccessDatabase plotPlayerAccessDatabase;

    @Override
    protected RepositoryDatasource<PlotPlayerAccess, PlotPlayerAccessKey> getDatasource() {
        return this.plotPlayerAccessDatabase;
    }

    @Override
    protected RepositoryUpdatePolicy updatePolicy() {
        return RepositoryUpdatePolicy.REPLACE;
    }

    public Optional<PlotPlayerAccess> findByPlotAndPlayer(int plotId, int playerId) {
        return this.findByKeyIfExists(new PlotPlayerAccessKey(plotId, playerId));
    }

    public List<PlotPlayerAccess> findByPlot(int plotId) {
        return this.findListByPredicates((T p) -> p.getPlotId() == plotId);
    }

    public List<PlotPlayerAccess> findByPlayer(int playerId) {
        return this.findListByPredicates((T p) -> p.getPlayerId() == playerId);
    }
}

