/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.plot.access;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.PlayerTransformer;
import com.equestricraft.core.plot.Plot;
import com.equestricraft.core.plot.access.PlotAccessInfo;
import com.equestricraft.core.plot.access.PlotAccessLevel;
import com.equestricraft.core.plot.access.PlotPlayerAccess;
import com.equestricraft.core.plot.access.PlotPlayerAccessKey;
import com.equestricraft.core.plot.access.PlotPlayerAccessRepository;
import com.equestricraft.core.plot.access.PlotPlayerAccessSession;
import java.util.List;
import java.util.Optional;

public class PlotPlayerAccessSessionImpl
implements PlotPlayerAccessSession {
    @Service
    private PlotPlayerAccessRepository plotPlayerAccessRepository;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private PlayerTransformer playerTransformer;

    @Override
    public PlotAccessLevel retrievePlayersAccessLevelToPlot(ECPlayer player, Plot plot) {
        if (plot.getOwnerIds().contains(player.getId())) {
            return PlotAccessLevel.OWNER;
        }
        return this.plotPlayerAccessRepository.findByPlotAndPlayer(plot.getId(), player.getId()).map(a -> a.isEdit() ? PlotAccessLevel.EDIT : PlotAccessLevel.ACCESS).orElse(PlotAccessLevel.NONE);
    }

    @Override
    public void grantPlayerAccessToPlot(ECPlayer player, Plot plot) {
        this.grantAccessToPlayerForPlot(player, plot, false);
    }

    @Override
    public void grantPlayerEditAccessToPlot(ECPlayer player, Plot plot) {
        this.grantAccessToPlayerForPlot(player, plot, true);
    }

    private void grantAccessToPlayerForPlot(ECPlayer player, Plot plot, boolean edit) {
        if (plot.getOwnerIds().contains(player.getId())) {
            throw new IllegalArgumentException("Plot owner already has full access");
        }
        Optional<PlotPlayerAccess> existing = this.plotPlayerAccessRepository.findByPlotAndPlayer(plot.getId(), player.getId());
        if (existing.isPresent()) {
            existing.get().setEdit(edit);
        } else {
            PlotPlayerAccess newAccess = new PlotPlayerAccess(plot.getId(), player.getId(), edit);
            this.plotPlayerAccessRepository.add(newAccess);
        }
    }

    @Override
    public void revokePlayersAccessToPlot(ECPlayer player, Plot plot) {
        if (plot.getOwnerIds().contains(player.getId())) {
            throw new IllegalArgumentException("Cannot revoke access from owner");
        }
        this.plotPlayerAccessRepository.removeByKey(new PlotPlayerAccessKey(plot.getId(), player.getId()));
    }

    @Override
    public List<PlotAccessInfo> retrieveAllAccessesForPlot(int plotId) {
        List<PlotPlayerAccess> info2 = this.plotPlayerAccessRepository.findByPlot(plotId);
        return info2.stream().map(this::buildAccessInfo).toList();
    }

    private PlotAccessInfo buildAccessInfo(PlotPlayerAccess plotPlayerAccess) {
        CorePlayer player = (CorePlayer)this.playerRepository.findByKey(plotPlayerAccess.getPlayerId());
        return new PlotAccessInfo(this.playerTransformer.toSimple(player), plotPlayerAccess.isEdit() ? PlotAccessLevel.EDIT : PlotAccessLevel.ACCESS);
    }

    @Override
    public List<Integer> retrievePlotsPlayerHasAccessTo(ECPlayer player) {
        List<PlotPlayerAccess> access = this.plotPlayerAccessRepository.findByPlayer(player.getId());
        return access.stream().map(PlotPlayerAccess::getPlotId).toList();
    }
}

