/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.plot.approval;

import com.equestricraft.base.response.Response;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.plot.Plot;
import com.equestricraft.core.plot.approval.PlotActionRunnable;
import com.equestricraft.core.plot.approval.PlotActionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class PlotApprovalAction {
    private final PlotActionType actionType;
    private final Plot plot;
    private final PlotActionRunnable action;
    private final CompletableFuture<Response> futureResponse;
    private final Date createdDate = new Date();
    private final List<ECPlayer> approvedPlayers = new ArrayList<ECPlayer>();

    protected PlotApprovalAction(PlotActionType actionType, Plot plot, PlotActionRunnable action, CompletableFuture<Response> futureResponse) {
        this.actionType = actionType;
        this.plot = plot;
        this.action = action;
        this.futureResponse = futureResponse;
    }

    public PlotActionType getActionType() {
        return this.actionType;
    }

    public Plot getPlot() {
        return this.plot;
    }

    public PlotActionRunnable getAction() {
        return this.action;
    }

    public CompletableFuture<Response> getFutureResponse() {
        return this.futureResponse;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public synchronized void addApprovedPlayer(ECPlayer player) {
        boolean alreadyAdded = this.approvedPlayers.stream().anyMatch(p -> p.getId() == player.getId());
        if (!alreadyAdded) {
            this.approvedPlayers.add(player);
        }
    }

    public List<ECPlayer> getApprovedPlayers() {
        return Collections.unmodifiableList(this.approvedPlayers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlotApprovalAction that = (PlotApprovalAction)o;
        return this.actionType == that.actionType && Objects.equals(this.plot, that.plot);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.actionType, this.plot});
    }

    public String toString() {
        return this.plot.toString() + " " + this.actionType.getTranslatedName();
    }
}

