/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.plot.approval;

import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.common.ListMap;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.plot.Plot;
import com.equestricraft.core.plot.approval.PlotActionType;
import com.equestricraft.core.plot.approval.PlotApprovalAction;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Predicate;

public class PlotApprovalActionCache {
    private static final PlotApprovalActionCache instance = new PlotApprovalActionCache();
    private final ListMap<Plot, PlotApprovalAction> approvalActions = new ListMap();
    private final StampedLock lock = new StampedLock();

    public static PlotApprovalActionCache getInstance() {
        return instance;
    }

    private PlotApprovalActionCache() {
        this.startCancelTimer();
    }

    private void startCancelTimer() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                PlotApprovalActionCache.this.cancelExpiredApprovals();
            }
        }, 3600000L, 3600000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelExpiredApprovals() {
        long stamp = this.lock.writeLock();
        try {
            Set<Plot> plots = this.approvalActions.getAllKeys();
            for (Plot plot : plots) {
                this.approvalActions.get(plot).stream().filter(this::hasApprovalExpired).forEach(this::cancelApproval);
            }
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private boolean hasApprovalExpired(PlotApprovalAction approvalAction) {
        Duration durationSinceCreated = DateUtils.durationSince(approvalAction.getCreatedDate());
        return durationSinceCreated.toHours() > 24L;
    }

    private void cancelApproval(PlotApprovalAction approvalAction) {
        this.approvalActions.remove(approvalAction.getPlot(), approvalAction);
        String message = I18n.getLabel("plot.approval-expired", approvalAction.getActionType().getTranslatedName(), approvalAction.getPlot().getName());
        approvalAction.getFutureResponse().complete(ResponseFactory.fail(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApprovalAction(PlotApprovalAction plotApprovalAction) {
        long stamp = this.lock.writeLock();
        try {
            this.approvalActions.add(plotApprovalAction.getPlot(), plotApprovalAction);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<PlotApprovalAction> getActionForPlotAndType(Plot plot, PlotActionType actionType) {
        long stamp = this.lock.readLock();
        try {
            List<PlotApprovalAction> actionsForPlot = this.approvalActions.get(plot);
            Optional<PlotApprovalAction> optional = actionsForPlot.stream().filter(a -> a.getActionType().equals((Object)actionType)).filter(Predicate.not(this::hasApprovalExpired)).findFirst();
            return optional;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PlotApprovalAction> getAllActionsForPlayersOwnedPlots(ECPlayer player) {
        long stamp = this.lock.readLock();
        try {
            List<PlotApprovalAction> list = this.approvalActions.getAllKeys().stream().filter(p -> p.getOwnerIds().contains(player.getId())).flatMap(p -> this.approvalActions.get((Plot)p).stream()).filter(Predicate.not(this::hasApprovalExpired)).toList();
            return list;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApprovalAction(PlotApprovalAction plotApprovalAction) {
        long stamp = this.lock.writeLock();
        try {
            this.approvalActions.remove(plotApprovalAction.getPlot(), plotApprovalAction);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }
}

