/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.plot.approval;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.plot.Plot;
import com.equestricraft.core.plot.PlotException;
import com.equestricraft.core.plot.PlotPermissionChecker;
import com.equestricraft.core.plot.PlotPermissionException;
import com.equestricraft.core.plot.approval.PlotActionRunnable;
import com.equestricraft.core.plot.approval.PlotActionType;
import com.equestricraft.core.plot.approval.PlotApprovalAction;
import com.equestricraft.core.plot.approval.PlotApprovalActionCache;
import com.equestricraft.core.plot.approval.PlotApprovalSession;
import com.equestricraft.core.plot.approval.PlotPendingApprovalInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

public class PlotApprovalSessionImpl
implements PlotApprovalSession {
    @Service
    private PlayerRepository playerRepository;
    private final PlotApprovalActionCache plotApprovalActionCache = PlotApprovalActionCache.getInstance();

    @Override
    public Response executeWithApproval(PlotActionType actionType, Plot plot, ECPlayer player, PlotActionRunnable action) throws PlotException {
        Optional<PlotApprovalAction> existing = this.plotApprovalActionCache.getActionForPlotAndType(plot, actionType);
        if (existing.isPresent()) {
            throw new PlotException(I18n.getLabel("plot.action.already-exists"));
        }
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        PlotApprovalAction newAction = new PlotApprovalAction(actionType, plot, action, future);
        this.plotApprovalActionCache.addApprovalAction(newAction);
        return this.provideApproval(newAction, player);
    }

    @Override
    public Response provideApproval(Plot plot, PlotActionType actionType, ECPlayer player) throws PlotException {
        PlotApprovalAction action = this.plotApprovalActionCache.getActionForPlotAndType(plot, actionType).orElseThrow(() -> new PlotException(I18n.getLabel("plot.pending-approval.expired")));
        return this.provideApproval(action, player);
    }

    @Override
    public List<PlotPendingApprovalInfo> getPendingApprovalsForPlayer(ECPlayer player) {
        List<PlotApprovalAction> pending = this.plotApprovalActionCache.getAllActionsForPlayersOwnedPlots(player);
        return pending.stream().map(p -> new PlotPendingApprovalInfo(p.getActionType(), p.getPlot().getId(), p.getPlot().getName(), p.getApprovedPlayers().contains(player))).toList();
    }

    @Override
    public Response cancelAction(Plot plot, PlotActionType plotActionType) {
        Optional<PlotApprovalAction> action = this.plotApprovalActionCache.getActionForPlotAndType(plot, plotActionType);
        if (action.isPresent()) {
            this.plotApprovalActionCache.removeApprovalAction(action.get());
            String message = I18n.getLabel("plot.action-cancelled", action.get().getActionType().getTranslatedName(), action.get().getPlot().getName());
            action.get().getFutureResponse().complete(ResponseFactory.success(message));
            return ResponseFactory.success(message);
        }
        return ResponseFactory.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response provideApproval(PlotApprovalAction action, ECPlayer player) throws PlotPermissionException {
        PlotPermissionChecker.ensureOwnerAccess(player, action.getPlot());
        action.addApprovedPlayer(player);
        if (this.areApprovalsStillNeeded(action)) {
            this.notifyUnapprovedPlayers(action);
            player.sendMessage(I18n.getLabel("plot.approval-needed"));
            return ResponseFactory.future(action.getFutureResponse());
        }
        try {
            Response response = action.getAction().execute();
            action.getFutureResponse().complete(response);
            Response response2 = response;
            return response2;
        }
        catch (PlotException ex) {
            Response response = ResponseFactory.fail(ex);
            action.getFutureResponse().complete(response);
            Response response3 = response;
            return response3;
        }
        finally {
            this.plotApprovalActionCache.removeApprovalAction(action);
        }
    }

    private boolean areApprovalsStillNeeded(PlotApprovalAction action) {
        List<ECPlayer> approvedPlayers = action.getApprovedPlayers();
        return action.getPlot().getOwners().stream().anyMatch(Predicate.not(approvedPlayers::contains));
    }

    private void notifyUnapprovedPlayers(PlotApprovalAction action) {
        ArrayList<CorePlayer> owners = new ArrayList<CorePlayer>(action.getPlot().getOwners());
        for (ECPlayer approvedPlayer : action.getApprovedPlayers()) {
            owners.removeIf(approvedPlayer::equals);
        }
        String message = I18n.getLabel("plot.approval-reminder", action.getActionType().getTranslatedName(), action.getPlot().getName());
        for (CorePlayer player : owners) {
            player.sendMessage(message);
        }
    }
}

