/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.plot.map.grid;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.Area2D;
import com.equestricraft.common.coordinate.AreaUtility;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.coordinate.Point2D;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.plot.GridPlot;
import com.equestricraft.core.plot.PlotCoordinateUtility;
import com.equestricraft.core.plot.PlotRepository;
import com.equestricraft.core.plot.access.PlotAccessLevel;
import com.equestricraft.core.plot.access.PlotPlayerAccessSession;
import com.equestricraft.core.plot.map.PlotMapItemType;
import com.equestricraft.core.plot.map.grid.PlotGridMapItem;
import com.equestricraft.core.plot.map.grid.PlotGridMapSession;
import java.util.List;

public class PlotGridMapSessionImpl
implements PlotGridMapSession {
    @Service
    private PlotRepository plotRepository;
    @Service
    private PlotPlayerAccessSession plotPlayerAccessSession;

    @Override
    public List<PlotGridMapItem> retrieveSurroundingMapData(Coordinate coordinate, ECPlayer player) {
        Area2D searchArea = AreaUtility.buildAreaFromPoint(new Point2D((int)coordinate.x(), (int)coordinate.z()), 2010);
        List<GridPlot> allPlots = this.plotRepository.findAllGridPlots();
        Point2D point = new Point2D((int)coordinate.x(), (int)coordinate.z());
        return allPlots.stream().map(this::buildMapping).filter(m -> m.areas().stream().anyMatch(searchArea::overlapsWith)).map(m -> new PlotGridMapItem(m.plot().getId(), m.plot().getAreas(), this.determineType((PlotAreaMapping)m, player, point))).toList();
    }

    private PlotMapItemType determineType(PlotAreaMapping plot, ECPlayer player, Point2D point) {
        if (plot.areas().stream().anyMatch(a -> a.containsPoint(point))) {
            return PlotMapItemType.CURRENT_PLOT;
        }
        PlotAccessLevel accessLevel = this.plotPlayerAccessSession.retrievePlayersAccessLevelToPlot(player, plot.plot());
        return switch (accessLevel) {
            default -> throw new IncompatibleClassChangeError();
            case PlotAccessLevel.NONE -> PlotMapItemType.NO_ACCESS_PLOT;
            case PlotAccessLevel.ACCESS, PlotAccessLevel.EDIT -> PlotMapItemType.ACCESS_PLOT;
            case PlotAccessLevel.OWNER -> PlotMapItemType.OWNED_PLOT;
        };
    }

    private PlotAreaMapping buildMapping(GridPlot plot) {
        List<Area2D> areas = plot.getAreas().stream().map(PlotCoordinateUtility::getAreaOfPlotCoordinate).toList();
        return new PlotAreaMapping(plot, areas);
    }

    record PlotAreaMapping(GridPlot plot, List<Area2D> areas) {
    }
}

