/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.plot.map.natural;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.Area2D;
import com.equestricraft.common.coordinate.AreaUtility;
import com.equestricraft.common.coordinate.Point2D;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.plot.NaturalPlot;
import com.equestricraft.core.plot.Plot;
import com.equestricraft.core.plot.PlotAreaSession;
import com.equestricraft.core.plot.PlotRepository;
import com.equestricraft.core.plot.access.PlotAccessLevel;
import com.equestricraft.core.plot.access.PlotPlayerAccessSession;
import com.equestricraft.core.plot.map.natural.PlotNaturalMapItem;
import com.equestricraft.core.plot.map.natural.PlotNaturalMapSession;
import com.equestricraft.core.plot.setting.PlotGlobalSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PlotNaturalMapSessionImpl
implements PlotNaturalMapSession {
    @Service
    private PlotRepository plotRepository;
    @Service
    private PlotAreaSession plotAreaSession;
    @Service
    private PlotPlayerAccessSession plotPlayerAccessSession;

    @Override
    public List<PlotNaturalMapItem> retrieveNaturalPlotMapItems(ECPlayer player, Point2D point) {
        Area2D areaLimit = AreaUtility.createAreaFromPointAndRadius(point, 200);
        List<NaturalPlot> allPlots = this.plotRepository.findAllNaturalPlots();
        List<PlotWithAreas> plotWithAreas = new ArrayList<PlotWithAreas>();
        for (NaturalPlot plot : allPlots) {
            List<Area2D> areas = this.plotAreaSession.retrieveAreasForPlot(plot);
            int minimapRange = PlotGlobalSettings.get().getMinimapRange();
            boolean hasAreaWithinDistance = areas.stream().anyMatch(a -> a.withinDistanceOf(minimapRange, point));
            if (!hasAreaWithinDistance) continue;
            areas = areas.stream().filter(a -> a.overlapsWith(areaLimit)).map(a -> AreaUtility.createIntersection(a, areaLimit)).toList();
            PlotWithAreas plotArea = new PlotWithAreas(plot, areas);
            plotWithAreas.add(plotArea);
        }
        if (plotWithAreas.isEmpty()) {
            return Collections.emptyList();
        }
        plotWithAreas = this.transformCoordinates(plotWithAreas, areaLimit);
        ArrayList<PlotNaturalMapItem> items = new ArrayList<PlotNaturalMapItem>(plotWithAreas.size());
        for (PlotWithAreas plotArea : plotWithAreas) {
            boolean owner = plotArea.plot().getOwnerIds().contains(player.getId());
            boolean accessible = owner || this.plotPlayerAccessSession.retrievePlayersAccessLevelToPlot(player, plotArea.plot()).isAtLeast(PlotAccessLevel.ACCESS);
            PlotNaturalMapItem item = new PlotNaturalMapItem(plotArea.areas(), plotArea.plot().getName(), owner, accessible);
            items.add(item);
        }
        return items;
    }

    private List<PlotWithAreas> transformCoordinates(List<PlotWithAreas> plotItems, Area2D enclosingArea) {
        if (plotItems.isEmpty()) {
            return plotItems;
        }
        int xOffset = -enclosingArea.x1();
        int zOffset = -enclosingArea.z1();
        float scaleFactor = enclosingArea.x2() > enclosingArea.z2() ? (float)(80.0 / (double)(enclosingArea.x2() + xOffset)) : (float)(80.0 / (double)(enclosingArea.z2() + zOffset));
        return plotItems.stream().map(p -> {
            List<Area2D> newAreas = p.areas().stream().map(a -> a.shiftX(xOffset).shiftZ(zOffset)).map(a -> a.transformScale(scaleFactor)).toList();
            return new PlotWithAreas(p.plot(), newAreas);
        }).toList();
    }

    record PlotWithAreas(Plot plot, List<Area2D> areas) {
    }
}

