/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.plot.setting;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.plot.setting.PlotGlobalSettings;
import java.util.List;

public class PlotGlobalSettingsDatabase
implements RepositoryDatasource<PlotGlobalSettings, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_PRICE_PER_SQUARE = "PRICE_PER_SQUARE";
    private static final String COLUMN_PLOT_GAP = "PLOT_GAP";
    private static final String COLUMN_MINIMUM_PLOT_RADIUS = "MINIMUM_PLOT_RADIUS";
    private static final String COLUMN_SPAWN_POINT = "SPAWN_POINT";
    private static final String COLUMN_SPAWN_POINT_PROTECTION_RADIUS = "SPAWN_POINT_PROTECTION_RADIUS";
    private static final String COLUMN_MINIMAP_RANGE = "MINIMAP_RANGE";
    private static final String COLUMN_GRID_PRICE = "GRID_PRICE";

    @Override
    public List<PlotGlobalSettings> retrieveAll() {
        return Query.selectAllFrom("PLOT_GLOBAL_SETTINGS").getList(this::getPlotGlobalSettingsFromResultRow);
    }

    private PlotGlobalSettings getPlotGlobalSettingsFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        double pricePerSquare = row.getDouble(COLUMN_PRICE_PER_SQUARE);
        int plotGap = row.getInt(COLUMN_PLOT_GAP);
        int minimumPlotRadius = row.getInt(COLUMN_MINIMUM_PLOT_RADIUS);
        DirectionalCoordinate spawnPoint = row.getDirectionalCoordinate(COLUMN_SPAWN_POINT);
        int spawnPointProtectionRadius = row.getInt(COLUMN_SPAWN_POINT_PROTECTION_RADIUS);
        int minimapRange = row.getInt(COLUMN_MINIMAP_RANGE);
        double gridPrice = row.getDouble(COLUMN_GRID_PRICE);
        return new PlotGlobalSettings(id, pricePerSquare, plotGap, minimumPlotRadius, spawnPoint, spawnPointProtectionRadius, minimapRange, gridPrice);
    }
}

