/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.provision;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.common.ProvisionType;
import com.equestricraft.core.item.AbstractItemDatabase;
import com.equestricraft.core.item.ECItemDetails;
import com.equestricraft.core.item.ItemTag;
import com.equestricraft.core.nutrient.Nutrient;
import com.equestricraft.core.provision.Provision;
import com.equestricraft.core.provision.ProvisionNutrient;
import java.util.List;

public class ProvisionDatabase
extends AbstractItemDatabase {
    public Provision getProvisionFromItem(ECItemDetails details) {
        return Query.selectAllFrom("PROVISION").where(QueryColumn.column("ID", details.id())).getSingle(row -> this.getProvisionFromResultRow(row, details)).orElseThrow();
    }

    private Provision getProvisionFromResultRow(ResultRow row, ECItemDetails details) {
        Integer expiryStartDays = row.getNullableInt("EXPIRY_START_DAYS");
        Integer expiryEndDays = row.getNullableInt("EXPIRY_END_DAYS");
        ProvisionType provisionType = row.getEnum("TYPE", ProvisionType.class);
        double gramsPerUnit = row.getDouble("GRAMS_PER_UNIT");
        boolean divisible = row.getBoolean("DIVISIBLE");
        double spoilChance = row.getDouble("SPOIL_CHANCE");
        List<ProvisionNutrient> provisionNutrients = this.getAllNutrientsForProvision(details.id());
        List<ItemTag> tags = this.getTags(details);
        return new Provision(details.id(), details.name(), details.identifier(), details.description(), details.modItemName(), tags, expiryStartDays, expiryEndDays, provisionType, gramsPerUnit, divisible, spoilChance, provisionNutrients);
    }

    private List<ProvisionNutrient> getAllNutrientsForProvision(int provisionId) {
        return Query.selectAllFrom("PROVISION_NUTRIENT").where(QueryColumn.column("PROVISION_ID", provisionId)).getList(this::getProvisionNutrientFromResultRow);
    }

    private ProvisionNutrient getProvisionNutrientFromResultRow(ResultRow row) {
        Nutrient nutrient = row.getEnum("NUTRIENT_IDENTIFIER", Nutrient.class);
        double value = row.getDouble("VALUE");
        double valueReduced = row.getDouble("VALUE_REDUCED");
        return new ProvisionNutrient(nutrient, value, valueReduced);
    }
}

