/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest;

import com.equestricraft.common.util.ListUtils;
import com.equestricraft.core.quest.QuestOutputWeight;
import com.equestricraft.core.quest.QuestTargetOutputConfiguration;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public class OutputIdentifierFunction
extends Closure<Void> {
    private final List<QuestOutputWeight> outputs = new ArrayList<QuestOutputWeight>();
    private int outputsToActivate = 1;
    private boolean success = false;
    private boolean failure = false;

    public OutputIdentifierFunction() {
        super(null);
    }

    @Override
    public Void call(Object ... args2) {
        if (args2.length >= 1) {
            Object value = args2[0];
            if (value instanceof String) {
                String string = (String)value;
                this.outputs.clear();
                QuestOutputWeight output = new QuestOutputWeight(string, 100);
                this.outputs.add(output);
            } else if (value instanceof Closure) {
                Closure closure = (Closure)value;
                this.outputs.clear();
                QuestTargetOutputConfiguration outputConfiguration = new QuestTargetOutputConfiguration();
                closure.setDelegate(outputConfiguration);
                closure.call();
                this.outputs.addAll(outputConfiguration.getOutputs());
                this.outputsToActivate = outputConfiguration.getOutputsToActivate();
                this.success = outputConfiguration.isSuccess();
                this.failure = outputConfiguration.isFailure();
            }
        }
        return null;
    }

    public List<String> pickRandoms() {
        if (this.outputs.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.outputsToActivate > this.outputs.size()) {
            throw new IllegalArgumentException("Required outputs is less than the outputs that have been defined");
        }
        ArrayList<QuestOutputWeight> outputsToPickFrom = new ArrayList<QuestOutputWeight>(this.outputs);
        HashSet<String> selectedOutputs = new HashSet<String>();
        while (selectedOutputs.size() < this.outputsToActivate) {
            QuestOutputWeight output = ListUtils.getRandomWeightedItem(outputsToPickFrom, QuestOutputWeight::weight);
            selectedOutputs.add(output.identifier());
            outputsToPickFrom.remove(output);
        }
        return new ArrayList<String>(selectedOutputs);
    }

    public Optional<String> pickRandomSingle() {
        if (this.outputs.isEmpty()) {
            return Optional.empty();
        }
        QuestOutputWeight output = this.outputs.size() == 1 ? this.outputs.get(0) : ListUtils.getRandomItem(this.outputs);
        return Optional.of(output.identifier());
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isFailure() {
        return this.failure;
    }
}

