/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.common.QuestState;
import com.equestricraft.common.QuestType;
import com.equestricraft.core.quest.QuestAdapter;
import com.equestricraft.core.quest.QuestRewards;
import com.equestricraft.core.quest.element.QuestElement;
import com.equestricraft.core.quest.element.QuestStartElement;
import com.equestricraft.core.quest.placeholder.QuestLocalPlaceholder;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;

public class Quest
extends QuestAdapter
implements RepositoryEntity<Integer> {
    private final int id;
    private final String name;
    private final String notYetPlayedDescription;
    private final String hasBeenPlayedDescription;
    private final QuestType questType;
    private final Integer questStoryGroupId;
    private final String storyGroupHighlight;
    private final String askMessage;
    private final boolean showStartTitle;
    private final String customStartTitleText;
    private QuestRewards rewards;
    private final String onAbandonScript;
    private final boolean hiddenFromMenuWhenNotComplete;
    private final QuestState questState;
    private final boolean achievement;
    private final boolean showOnProgression;
    private List<QuestElement> elements;
    private List<QuestLocalPlaceholder> localPlaceholders;

    public Quest(int id, String name, String notYetPlayedDescription, String hasBeenPlayedDescription, QuestType questType, Integer questStoryGroupId, String storyGroupHighlight, String askMessage, boolean showStartTitle, String customStartTitleText, QuestRewards rewards, String onAbandonScript, boolean hiddenFromMenuWhenNotComplete, QuestState questState, boolean achievement, boolean showOnProgression) {
        this.id = id;
        this.name = name;
        this.notYetPlayedDescription = notYetPlayedDescription;
        this.hasBeenPlayedDescription = hasBeenPlayedDescription;
        this.questType = questType;
        this.questStoryGroupId = questStoryGroupId;
        this.storyGroupHighlight = storyGroupHighlight;
        this.askMessage = askMessage;
        this.showStartTitle = showStartTitle;
        this.customStartTitleText = customStartTitleText;
        this.rewards = rewards;
        this.onAbandonScript = onAbandonScript;
        this.hiddenFromMenuWhenNotComplete = hiddenFromMenuWhenNotComplete;
        this.questState = questState;
        this.achievement = achievement;
        this.showOnProgression = showOnProgression;
    }

    @Override
    public Integer getKey() {
        return this.getId();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNotYetPlayedDescription() {
        return this.notYetPlayedDescription;
    }

    public String getHasBeenPlayedDescription() {
        return this.hasBeenPlayedDescription;
    }

    public QuestType getQuestType() {
        return this.questType;
    }

    @Override
    public Integer getQuestStoryGroupId() {
        return this.questStoryGroupId;
    }

    public String getStoryGroupHighlight() {
        return this.storyGroupHighlight;
    }

    public String getAskMessage() {
        return this.askMessage;
    }

    public boolean isShowStartTitle() {
        return this.showStartTitle;
    }

    public String getCustomStartTitleText() {
        return this.customStartTitleText;
    }

    public QuestRewards getRewards() {
        return this.rewards;
    }

    public void setRewards(QuestRewards rewards) {
        this.rewards = rewards;
    }

    public List<QuestElement> getElements() {
        return this.elements;
    }

    public QuestElement getElementById(UUID id) {
        return this.getElements().stream().filter(e -> e.getId().equals(id)).findFirst().orElseThrow();
    }

    public QuestElement getElementByNameKey(String nameKey) {
        return this.getElements().stream().filter(e -> e.getNameKey().equals(nameKey)).findFirst().orElseThrow();
    }

    public Stream<QuestStartElement> getTimeActiveStartingElements() {
        return this.getElements().stream().filter(QuestStartElement.class::isInstance).map(QuestStartElement.class::cast).filter(QuestStartElement::isTimeActive);
    }

    protected void setElements(List<QuestElement> elements) {
        this.elements = elements;
    }

    public List<QuestLocalPlaceholder> getLocalPlaceholders() {
        return this.localPlaceholders;
    }

    public List<QuestLocalPlaceholder> getLocalPlaceholders(List<String> identifiers) {
        return this.getLocalPlaceholders().stream().filter(p -> identifiers.contains(p.getIdentifier())).toList();
    }

    protected void setLocalPlaceholders(List<QuestLocalPlaceholder> localPlaceholders) {
        this.localPlaceholders = localPlaceholders;
    }

    public String getOnAbandonScript() {
        return this.onAbandonScript;
    }

    public boolean isHiddenFromMenuWhenNotComplete() {
        return this.hiddenFromMenuWhenNotComplete;
    }

    public QuestState getQuestState() {
        return this.questState;
    }

    public boolean isLive() {
        return this.questState == QuestState.LIVE;
    }

    public boolean isArchived() {
        return this.questState == QuestState.ARCHIVED;
    }

    public boolean isAchievement() {
        return this.achievement;
    }

    public boolean isShowOnProgression() {
        return this.showOnProgression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quest quest = (Quest)o;
        return this.id == quest.id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return this.id + " - " + this.name;
    }
}

