/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceIgnore;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.achievement.PlayerAchievementProvider;
import com.equestricraft.core.player.achievement.PlayerAchievementsProvider;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestRepository;
import com.equestricraft.core.quest.log.QuestLogSession;
import java.util.List;
import java.util.stream.Stream;

public class QuestAchievementProvider
implements PlayerAchievementsProvider {
    @Service
    private QuestRepository questRepository;
    @Service
    private QuestLogSession questLogSession;

    @Override
    public Stream<? extends PlayerAchievementProvider> getAchievements() {
        List<Quest> achievementQuests = this.questRepository.findQuestsAsAchievements();
        return achievementQuests.stream().map(x$0 -> new QuestAchievement((Quest)x$0));
    }

    @ServiceIgnore
    private class QuestAchievement
    implements PlayerAchievementProvider {
        private final Quest quest;

        public QuestAchievement(Quest quest) {
            this.quest = quest;
        }

        @Override
        public String getIdentifier() {
            return "quest-" + this.quest.getId();
        }

        @Override
        public String getName() {
            return this.quest.getName();
        }

        @Override
        public String getDescription() {
            return this.quest.getHasBeenPlayedDescription();
        }

        @Override
        public double getPercentageProgression(ECPlayer player) {
            return QuestAchievementProvider.this.questLogSession.hasPlayerCompletedQuest(player, this.quest.getId()) ? 100.0 : 0.0;
        }
    }
}

