/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest;

import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.core.npc.NPC;
import com.equestricraft.core.quest.QuestActionProcessSession;
import com.equestricraft.core.quest.QuestExecutor;
import com.equestricraft.core.quest.element.QuestBlockInteractObjective;
import com.equestricraft.core.quest.element.QuestConversationObjective;
import com.equestricraft.core.quest.element.QuestLocationChangeObjective;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionResponse;
import com.equestricraft.core.quest.element.objectivecheck.BlockInteractObjectiveCheck;
import com.equestricraft.core.quest.element.objectivecheck.LocationChangeObjectiveCheck;
import com.equestricraft.core.quest.element.objectivecheck.NpcObjectiveCheck;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.util.Optional;

public class QuestActionProcessSessionImpl
implements QuestActionProcessSession {
    @Override
    public Optional<QuestConversationActionResponse> processNPCTalk(QuestPlayer player, NPC npc, Object promptInput) {
        return QuestExecutor.executeQuestTask(player, () -> {
            Optional<QuestConversationObjective> objective = new NpcObjectiveCheck(npc).getObjectiveForEvent(player);
            return objective.map(o -> o.getLifecycle(player).advance(promptInput)).orElse(null);
        });
    }

    @Override
    public void processLocationChange(QuestPlayer player, Coordinate coordinate) {
        QuestExecutor.executeAsyncQuestTask(player, () -> {
            Optional<QuestLocationChangeObjective> objective = new LocationChangeObjectiveCheck(coordinate).getObjectiveForEvent(player);
            objective.ifPresent(o -> o.getLifecycle(player).advance());
        });
    }

    @Override
    public void processBlockInteract(QuestPlayer player, BlockCoordinate blockCoordinate) {
        QuestExecutor.executeAsyncQuestTask(player, () -> {
            Optional<QuestBlockInteractObjective> objective = new BlockInteractObjectiveCheck(blockCoordinate).getObjectiveForEvent(player);
            objective.ifPresent(o -> o.getLifecycle(player).advance(blockCoordinate));
        });
    }
}

