/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.worldarea.WorldArea;
import com.equestricraft.common.DaysOfWeek;
import com.equestricraft.common.QuestConversationLineSpeaker;
import com.equestricraft.common.QuestConversationPromptType;
import com.equestricraft.common.QuestElementOutputLinkInputType;
import com.equestricraft.common.QuestElementOutputType;
import com.equestricraft.common.QuestElementType;
import com.equestricraft.common.QuestEndType;
import com.equestricraft.common.QuestLocationChangeMode;
import com.equestricraft.common.QuestState;
import com.equestricraft.common.QuestType;
import com.equestricraft.common.QuestWaypointAction;
import com.equestricraft.common.Range;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestFollowObjectiveWaypoint;
import com.equestricraft.core.quest.QuestObjectiveBlockInteract;
import com.equestricraft.core.quest.QuestRewards;
import com.equestricraft.core.quest.RequiredCharacter;
import com.equestricraft.core.quest.RequiredQuest;
import com.equestricraft.core.quest.element.QuestBlockInteractObjective;
import com.equestricraft.core.quest.element.QuestConversationObjective;
import com.equestricraft.core.quest.element.QuestElement;
import com.equestricraft.core.quest.element.QuestElementOutput;
import com.equestricraft.core.quest.element.QuestElementOutputLink;
import com.equestricraft.core.quest.element.QuestEndElement;
import com.equestricraft.core.quest.element.QuestFollowNpcObjective;
import com.equestricraft.core.quest.element.QuestLocationChangeObjective;
import com.equestricraft.core.quest.element.QuestScriptElement;
import com.equestricraft.core.quest.element.QuestScriptedObjective;
import com.equestricraft.core.quest.element.QuestStartElement;
import com.equestricraft.core.quest.element.QuestStopwatchElement;
import com.equestricraft.core.quest.element.QuestTimerElement;
import com.equestricraft.core.quest.element.QuestWaitElement;
import com.equestricraft.core.quest.element.conversation.QuestConversationElement;
import com.equestricraft.core.quest.element.conversation.QuestConversationElementOutput;
import com.equestricraft.core.quest.element.conversation.QuestConversationPromptElement;
import com.equestricraft.core.quest.element.conversation.QuestConversationScriptElement;
import com.equestricraft.core.quest.element.conversation.QuestConversationTextElement;
import com.equestricraft.core.quest.element.conversation.QuestConversationTextElementLine;
import com.equestricraft.core.quest.element.conversation.QuestConversationTextElementLineWaypoint;
import com.equestricraft.core.quest.placeholder.QuestLocalPlaceholder;
import com.equestricraft.core.quest.prompt.QuestConversationPromptChoice;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class QuestDatabase
implements RepositoryDatasource<Quest, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_NOT_YET_PLAYED_DESCRIPTION = "NOT_YET_PLAYED_DESCRIPTION";
    private static final String COLUMN_HAS_BEEN_PLAYED_DESCRIPTION = "HAS_BEEN_PLAYED_DESCRIPTION";
    private static final String COLUMN_QUEST_TYPE = "QUEST_TYPE";
    private static final String COLUMN_QUEST_STORY_GROUP_ID = "QUEST_STORY_GROUP_ID";
    private static final String COLUMN_STORY_GROUP_HIGHLIGHT = "STORY_GROUP_HIGHLIGHT";
    private static final String COLUMN_BLOCK_INTERACT_COORDINATE = "BLOCK_INTERACT_COORDINATE";
    private static final String COLUMN_LOCATION_REACH_AREA = "LOCATION_REACH_AREA";
    private static final String COLUMN_START_TIME = "START_TIME";
    private static final String COLUMN_END_TIME = "END_TIME";
    private static final String COLUMN_ASK_MESSAGE = "ASK_MESSAGE";
    private static final String COLUMN_SHOW_START_TITLE = "SHOW_START_TITLE";
    private static final String COLUMN_CUSTOM_START_TITLE_TEXT = "CUSTOM_START_TITLE_TEXT";
    private static final String COLUMN_XP_REQUIRED = "XP_REQUIRED";
    private static final String COLUMN_FIRST_XP_REWARD = "FIRST_XP_REWARD";
    private static final String COLUMN_FIRST_MONEY_REWARD = "FIRST_MONEY_REWARD";
    private static final String COLUMN_REPLAY_XP_REWARD = "REPLAY_XP_REWARD";
    private static final String COLUMN_REPLAY_MONEY_REWARD = "REPLAY_MONEY_REWARD";
    private static final String COLUMN_ALLOW_MULTIPLE_PLAY = "ALLOW_MULTIPLE_PLAY";
    private static final String COLUMN_PLAY_COOL_DOWN_HOURS = "PLAY_COOL_DOWN_HOURS";
    private static final String COLUMN_PRE_CONDITION_SCRIPT = "PRE_CONDITION_SCRIPT";
    private static final String COLUMN_ON_COMPLETE_SCRIPT = "ON_COMPLETE_SCRIPT";
    private static final String COLUMN_ON_ABANDON_SCRIPT = "ON_ABANDON_SCRIPT";
    private static final String COLUMN_HIDDEN_FROM_MENU_WHEN_NOT_COMPLETE = "HIDDEN_FROM_MENU_WHEN_NOT_COMPLETE";
    private static final String COLUMN_PLAYABLE_DAYS = "PLAYABLE_DAYS";
    private static final String COLUMN_STATE = "STATE";
    private static final String COLUMN_ACHIEVEMENT = "ACHIEVEMENT";
    private static final String COLUMN_SHOW_ON_PROGRESSION = "SHOW_ON_PROGRESSION";
    private static final String COLUMN_QUEST_ID = "QUEST_ID";
    private static final String COLUMN_NAME_KEY = "NAME_KEY";
    private static final String COLUMN_START_MESSAGE = "START_MESSAGE";
    private static final String COLUMN_NPC_ID = "NPC_ID";
    private static final String COLUMN_LOCATION_CHANGE_AREA = "LOCATION_CHANGE_AREA";
    private static final String COLUMN_LOCATION_CHANGE_MODE = "LOCATION_CHANGE_MODE";
    private static final String COLUMN_FOLLOWING_NPC_ID = "FOLLOWING_NPC_ID";
    private static final String COLUMN_FOLLOWING_NPC_SPEED = "FOLLOWING_NPC_SPEED";
    private static final String COLUMN_PLAY_FIRST_ELEMENT = "PLAY_FIRST_ELEMENT";
    private static final String COLUMN_REQUIRED_OPTIONAL_BLOCK_INTERACTS = "REQUIRED_OPTIONAL_BLOCK_INTERACTS";
    private static final String COLUMN_PROMPT_SCRIPT = "PROMPT_SCRIPT";
    private static final String COLUMN_VALIDATION_SCRIPT = "VALIDATION_SCRIPT";
    private static final String COLUMN_PROCESSING_SCRIPT = "PROCESSING_SCRIPT";
    private static final String COLUMN_FOLLOW_MINIMUM_DISTANCE = "FOLLOW_MINIMUM_DISTANCE";
    private static final String COLUMN_FOLLOW_MAXIMUM_DISTANCE = "FOLLOW_MAXIMUM_DISTANCE";
    private static final String COLUMN_FOLLOW_TOO_CLOSE_MESSAGE = "FOLLOW_TOO_CLOSE_MESSAGE";
    private static final String COLUMN_FOLLOW_TOO_FAR_MESSAGE = "FOLLOW_TOO_FAR_MESSAGE";
    private static final String COLUMN_HINT = "HINT";
    private static final String COLUMN_SILENT = "SILENT";
    private static final String COLUMN_SHOW_TITLE = "SHOW_TITLE";
    private static final String COLUMN_SHOW_ON_COMPASS = "SHOW_ON_COMPASS";
    private static final String COLUMN_OBJECTIVE_ID = "OBJECTIVE_ID";
    private static final String COLUMN_OPTIONAL = "OPTIONAL";
    private static final String COLUMN_BLOCK_COORDINATE = "BLOCK_COORDINATE";
    private static final String COLUMN_BLOCK_TYPE = "BLOCK_TYPE";
    private static final String COLUMN_TEXT = "TEXT";
    private static final String COLUMN_TYPE = "TYPE";
    private static final String COLUMN_LINE_SPEAKER = "LINE_SPEAKER";
    private static final String COLUMN_AUTO_PLAY_NEXT_SECONDS = "AUTO_PLAY_NEXT_SECONDS";
    private static final String COLUMN_NPC_WAIT_MESSAGE = "NPC_WAIT_MESSAGE";
    private static final String COLUMN_REQUIRED_QUEST_ID = "REQUIRED_QUEST_ID";
    private static final String COLUMN_HOURS_WAIT = "HOURS_WAIT";
    private static final String COLUMN_MINIMUM_FRIENDSHIP = "MINIMUM_FRIENDSHIP";
    private static final String COLUMN_MAXIMUM_FRIENDSHIP = "MAXIMUM_FRIENDSHIP";
    private static final String COLUMN_REQUIRED_CHARACTER_ID = "REQUIRED_CHARACTER_ID";
    private static final String COLUMN_TITLE = "TITLE";
    private static final String COLUMN_PROMPT_ID = "PROMPT_ID";
    private static final String COLUMN_LABEL = "LABEL";
    private static final String COLUMN_DISPLAY_ORDER = "DISPLAY_ORDER";
    private static final String COLUMN_WAYPOINT_ORDER = "WAYPOINT_ORDER";
    private static final String COLUMN_LOCATION = "LOCATION";
    private static final String COLUMN_SPEED = "SPEED";
    private static final String COLUMN_IDENTIFIER = "IDENTIFIER";
    private static final String COLUMN_SCRIPT = "SCRIPT";
    private static final String COLUMN_OUTPUT_TYPE = "OUTPUT_TYPE";
    private static final String COLUMN_ELEMENT_ID = "ELEMENT_ID";
    private static final String COLUMN_OUTPUT_ID = "OUTPUT_ID";
    private static final String COLUMN_TARGET_ELEMENT_ID = "TARGET_ELEMENT_ID";
    private static final String COLUMN_INPUT_TYPE = "INPUT_TYPE";
    private static final String COLUMN_SCRIPT_TEXT = "SCRIPT_TEXT";
    private static final String COLUMN_END_TYPE = "END_TYPE";
    private static final String COLUMN_SHOW_END_TITLE = "SHOW_END_TITLE";
    private static final String COLUMN_END_MESSAGE = "END_MESSAGE";
    private static final String COLUMN_INPUTS_NEEDED = "INPUTS_NEEDED";
    private static final String COLUMN_TIMER_DURATION = "TIMER_DURATION";
    private static final String COLUMN_SILENT_TIMER = "SILENT_TIMER";
    private static final String COLUMN_SILENT_STOPWATCH = "SILENT_STOPWATCH";
    private static final String COLUMN_ELEMENT_TYPE = "ELEMENT_TYPE";
    private static final String COLUMN_STARTING_ELEMENT = "STARTING_ELEMENT";
    private static final String COLUMN_CONVERSATION_ELEMENT_ID = "CONVERSATION_ELEMENT_ID";
    private static final String COLUMN_NEXT_CONVERSATION_ELEMENT_ID = "NEXT_CONVERSATION_ELEMENT_ID";
    private static final String COLUMN_ELEMENT_OUTPUT_ID = "ELEMENT_OUTPUT_ID";
    private static final String COLUMN_CONVERSATION_ELEMENT_TYPE = "CONVERSATION_ELEMENT_TYPE";
    private static final String COLUMN_TEXT_ELEMENT_ID = "TEXT_ELEMENT_ID";
    private static final String COLUMN_CONVERSATION_ELEMENT_OUTPUT_ID = "CONVERSATION_ELEMENT_OUTPUT_ID";
    private static final String COLUMN_LINE_ID = "LINE_ID";
    private static final String COLUMN_START_ELEMENT_ID = "START_ELEMENT_ID";
    private static final String COLUMN_WAYPOINT_ID = "WAYPOINT_ID";
    private static final String COLUMN_ACTION_NAME = "ACTION_NAME";
    private static final String COLUMN_SECONDS_INTERVAL = "SECONDS_INTERVAL";

    @Override
    public List<Quest> retrieveAll() {
        return Query.selectAllFrom("QUEST").getList(this::getQuestFromResultRow);
    }

    @Override
    public Optional<Quest> retrieveByKey(Integer id) {
        return Query.selectAllFrom("QUEST").where(QueryColumn.column(COLUMN_ID, id)).getSingle(this::getQuestFromResultRow);
    }

    private Quest getQuestFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String notYetPlayedDescription = row.getString(COLUMN_NOT_YET_PLAYED_DESCRIPTION);
        String hasBeenPlayedDescription = row.getString(COLUMN_HAS_BEEN_PLAYED_DESCRIPTION);
        QuestType questType = row.getEnum(COLUMN_QUEST_TYPE, QuestType.class);
        Integer questStoryGroupId = row.getNullableInt(COLUMN_QUEST_STORY_GROUP_ID);
        String storyGroupHighlight = row.getNullableString(COLUMN_STORY_GROUP_HIGHLIGHT);
        String askMessage = row.getString(COLUMN_ASK_MESSAGE);
        boolean showStartTitle = row.getBoolean(COLUMN_SHOW_START_TITLE);
        String customStartTitleText = row.getNullableString(COLUMN_CUSTOM_START_TITLE_TEXT);
        int firstXpReward = row.getInt(COLUMN_FIRST_XP_REWARD);
        double firstMoneyReward = row.getDouble(COLUMN_FIRST_MONEY_REWARD);
        int replayXpReward = row.getInt(COLUMN_REPLAY_XP_REWARD);
        double replayMoneyReward = row.getDouble(COLUMN_REPLAY_MONEY_REWARD);
        QuestRewards rewards = new QuestRewards(firstXpReward, firstMoneyReward, replayXpReward, replayMoneyReward);
        String onAbandonScript = row.getNullableString(COLUMN_ON_ABANDON_SCRIPT);
        boolean hiddenFromMenuWhenNotComplete = row.getBoolean(COLUMN_HIDDEN_FROM_MENU_WHEN_NOT_COMPLETE);
        QuestState questState = row.getEnum(COLUMN_STATE, QuestState.class);
        boolean achievement = row.getBoolean(COLUMN_ACHIEVEMENT);
        boolean showOnProgression = row.getBoolean(COLUMN_SHOW_ON_PROGRESSION);
        Quest quest = new Quest(id, name, notYetPlayedDescription, hasBeenPlayedDescription, questType, questStoryGroupId, storyGroupHighlight, askMessage, showStartTitle, customStartTitleText, rewards, onAbandonScript, hiddenFromMenuWhenNotComplete, questState, achievement, showOnProgression);
        List<QuestElement> elements = this.getAllElementsForQuest(quest);
        List<QuestLocalPlaceholder> localPlaceholders = this.getLocalPlaceholdersForQuest(quest);
        quest.setElements(elements);
        quest.setLocalPlaceholders(localPlaceholders);
        return quest;
    }

    public List<QuestElementOutput> getOutputsForElement(QuestElement questElement) {
        return Query.selectAllFrom("QUEST_ELEMENT_OUTPUT").where(QueryColumn.column(COLUMN_ELEMENT_ID, questElement.getId())).getList(r -> this.getQuestElementOutputFromResultRow(r, questElement));
    }

    private QuestElementOutput getQuestElementOutputFromResultRow(ResultRow row, QuestElement questElement) {
        UUID id = row.getUuid(COLUMN_ID);
        QuestElementOutputType type = row.getEnum(COLUMN_OUTPUT_TYPE, QuestElementOutputType.class);
        String identifier = row.getString(COLUMN_IDENTIFIER);
        List<QuestElementOutputLink> links = this.getElementOutputLinksForOutput(id);
        return new QuestElementOutput(id, type, identifier, links, questElement);
    }

    private List<QuestElementOutputLink> getElementOutputLinksForOutput(UUID outputId) {
        return Query.selectAllFrom("QUEST_ELEMENT_OUTPUT_LINK").where(QueryColumn.column(COLUMN_OUTPUT_ID, outputId)).getList(this::getQuestElementOutputLinkFromResultRow);
    }

    private QuestElementOutputLink getQuestElementOutputLinkFromResultRow(ResultRow row) {
        UUID targetElementId = row.getUuid(COLUMN_TARGET_ELEMENT_ID);
        QuestElementOutputLinkInputType inputType = row.getEnum(COLUMN_INPUT_TYPE, QuestElementOutputLinkInputType.class);
        return new QuestElementOutputLink(targetElementId, inputType);
    }

    private List<QuestElement> getAllElementsForQuest(Quest quest) {
        List<QuestElement> questElements = Query.selectAllFrom("QUEST_ELEMENT").where(QueryColumn.column(COLUMN_QUEST_ID, quest.getId())).getList(this::getBasicQuestElementFromResultRow).stream().map(element -> this.buildQuestElement(quest, (BasicElement)element)).toList();
        this.linkOutputLinksToElements(questElements);
        return questElements;
    }

    private QuestElement buildQuestElement(Quest quest, BasicElement element) {
        QuestElement questElement = this.createElement(quest, element);
        List<QuestElementOutput> outputs = this.getOutputsForElement(questElement);
        this.linkConversationElementOutputs(questElement, outputs);
        questElement.setOutputs(outputs);
        return questElement;
    }

    private QuestElement createElement(Quest quest, BasicElement element) {
        return switch (element.elementType()) {
            default -> throw new IncompatibleClassChangeError();
            case QuestElementType.CONVERSATION -> Query.selectAllFrom("QUEST_CONVERSATION_OBJECTIVE").where(QueryColumn.column(COLUMN_ID, element.id())).getSingle(row -> this.getConversationObjectiveFromResultRow(quest, element, this.getBasicObjective(element.id()), row)).orElseThrow();
            case QuestElementType.BLOCK_INTERACT -> Query.selectAllFrom("QUEST_BLOCK_INTERACT_OBJECTIVE").where(QueryColumn.column(COLUMN_ID, element.id())).getSingle(row -> this.getBlockInteractObjectiveFromResultRow(quest, element, this.getBasicObjective(element.id()), row)).orElseThrow();
            case QuestElementType.FOLLOW_NPC -> Query.selectAllFrom("QUEST_FOLLOW_NPC_OBJECTIVE").where(QueryColumn.column(COLUMN_ID, element.id())).getSingle(row -> this.getFollowNpcObjectiveFromResultRow(quest, element, this.getBasicObjective(element.id()), row)).orElseThrow();
            case QuestElementType.LOCATION_CHANGE -> Query.selectAllFrom("QUEST_LOCATION_CHANGE_OBJECTIVE").where(QueryColumn.column(COLUMN_ID, element.id())).getSingle(row -> this.getLocationChangeObjectiveFromResultRow(quest, element, this.getBasicObjective(element.id()), row)).orElseThrow();
            case QuestElementType.SCRIPTED_OBJECTIVE -> Query.selectAllFrom("QUEST_SCRIPTED_OBJECTIVE").where(QueryColumn.column(COLUMN_ID, element.id())).getSingle(row -> this.getScriptedObjectiveFromResultRow(quest, element, this.getBasicObjective(element.id()), row)).orElseThrow();
            case QuestElementType.SCRIPT -> Query.selectAllFrom("QUEST_SCRIPT_ELEMENT").where(QueryColumn.column(COLUMN_ID, element.id())).getSingle(row -> this.getScriptElementFromResultRow(quest, element, row)).orElseThrow();
            case QuestElementType.END_QUEST -> Query.selectAllFrom("QUEST_END_ELEMENT").where(QueryColumn.column(COLUMN_ID, element.id())).getSingle(row -> this.getEndElementFromResultRow(quest, element, row)).orElseThrow();
            case QuestElementType.WAITER -> Query.selectAllFrom("QUEST_WAIT_ELEMENT").where(QueryColumn.column(COLUMN_ID, element.id())).getSingle(row -> this.getWaitElementFromResultRow(quest, element, row)).orElseThrow();
            case QuestElementType.TIMER -> Query.selectAllFrom("QUEST_TIMER_ELEMENT").where(QueryColumn.column(COLUMN_ID, element.id())).getSingle(row -> this.getTimerElementFromResultRow(quest, element, row)).orElseThrow();
            case QuestElementType.STOPWATCH -> Query.selectAllFrom("QUEST_STOPWATCH_ELEMENT").where(QueryColumn.column(COLUMN_ID, element.id())).getSingle(row -> this.getStopwatchElementFromResultRow(quest, element, row)).orElseThrow();
            case QuestElementType.STARTER -> Query.selectAllFrom("QUEST_START_ELEMENT").where(QueryColumn.column(COLUMN_ID, element.id())).getSingle(row -> this.getStartElementFromResultRow(quest, element, row)).orElseThrow();
        };
    }

    private QuestConversationObjective getConversationObjectiveFromResultRow(Quest quest, BasicElement element, BasicObjective basicObjective, ResultRow row) {
        Integer npcId = row.getNullableInt(COLUMN_NPC_ID);
        boolean playFirstElement = row.getBoolean(COLUMN_PLAY_FIRST_ELEMENT);
        QuestConversationObjective o = new QuestConversationObjective(element.id(), element.name(), element.nameKey(), quest, basicObjective.startMessage(), basicObjective.hint(), basicObjective.silent(), basicObjective.showTitle(), basicObjective.showOnCompass(), npcId, playFirstElement);
        List<QuestConversationElement> conversationElements = this.getAllConversationElementsForObjective(o);
        for (QuestConversationElement conversationElement : conversationElements) {
            for (QuestConversationElementOutput output : conversationElement.getOutputs()) {
                QuestConversationElement nextConversationElement = conversationElements.stream().filter(e -> e.getId().equals(output.getNextConversationElementId())).findFirst().orElse(null);
                output.setNextConversationElement(nextConversationElement);
            }
        }
        o.setElements(conversationElements);
        return o;
    }

    private QuestBlockInteractObjective getBlockInteractObjectiveFromResultRow(Quest quest, BasicElement element, BasicObjective basicObjective, ResultRow row) {
        Integer requiredOptionalBlockInteracts = row.getNullableInt(COLUMN_REQUIRED_OPTIONAL_BLOCK_INTERACTS);
        QuestBlockInteractObjective o = new QuestBlockInteractObjective(element.id(), element.name(), element.nameKey(), quest, basicObjective.startMessage(), basicObjective.hint(), basicObjective.silent(), basicObjective.showTitle(), basicObjective.showOnCompass(), requiredOptionalBlockInteracts);
        List<QuestObjectiveBlockInteract> blockInteracts = this.getAllBlockInteractsForObjective(o);
        o.setBlockInteracts(blockInteracts);
        return o;
    }

    private QuestFollowNpcObjective getFollowNpcObjectiveFromResultRow(Quest quest, BasicElement element, BasicObjective basicObjective, ResultRow row) {
        Integer npcId = row.getNullableInt(COLUMN_NPC_ID);
        int followMinimumDistance = row.getInt(COLUMN_FOLLOW_MINIMUM_DISTANCE);
        int followMaximumDistance = row.getInt(COLUMN_FOLLOW_MAXIMUM_DISTANCE);
        String followTooCloseMessage = row.getString(COLUMN_FOLLOW_TOO_CLOSE_MESSAGE);
        String followTooFarMessage = row.getString(COLUMN_FOLLOW_TOO_FAR_MESSAGE);
        QuestFollowNpcObjective o = new QuestFollowNpcObjective(element.id(), element.name(), element.nameKey(), quest, basicObjective.startMessage(), basicObjective.hint(), basicObjective.silent(), basicObjective.showTitle(), basicObjective.showOnCompass(), npcId, followMinimumDistance, followMaximumDistance, followTooCloseMessage, followTooFarMessage);
        List<QuestFollowObjectiveWaypoint> waypoints = this.getAllWaypointFollowsForObjective(o);
        o.setWaypoints(waypoints);
        return o;
    }

    private QuestLocationChangeObjective getLocationChangeObjectiveFromResultRow(Quest quest, BasicElement element, BasicObjective basicObjective, ResultRow row) {
        WorldArea locationChangeArea = row.getNullableWorldArea(COLUMN_LOCATION_CHANGE_AREA);
        QuestLocationChangeMode locationChangeMode = row.getNullableEnum(COLUMN_LOCATION_CHANGE_MODE, QuestLocationChangeMode.class);
        Integer followingNpcId = row.getNullableInt(COLUMN_FOLLOWING_NPC_ID);
        Double followingNpcSpeed = row.getNullableDouble(COLUMN_FOLLOWING_NPC_SPEED);
        return new QuestLocationChangeObjective(element.id(), element.name(), element.nameKey(), quest, basicObjective.startMessage(), basicObjective.hint(), basicObjective.silent(), basicObjective.showTitle(), basicObjective.showOnCompass(), locationChangeArea, locationChangeMode, followingNpcId, followingNpcSpeed);
    }

    private QuestScriptedObjective getScriptedObjectiveFromResultRow(Quest quest, BasicElement element, BasicObjective basicObjective, ResultRow row) {
        String script = row.getString(COLUMN_SCRIPT_TEXT);
        int secondsInterval = row.getInt(COLUMN_SECONDS_INTERVAL);
        return new QuestScriptedObjective(element.id(), element.name(), element.nameKey(), quest, basicObjective.startMessage(), basicObjective.hint(), basicObjective.silent(), basicObjective.showTitle(), basicObjective.showOnCompass(), script, secondsInterval);
    }

    private QuestScriptElement getScriptElementFromResultRow(Quest quest, BasicElement element, ResultRow row) {
        String scriptText = row.getString(COLUMN_SCRIPT_TEXT);
        return new QuestScriptElement(element.id(), element.name(), element.nameKey(), quest, scriptText);
    }

    private QuestEndElement getEndElementFromResultRow(Quest quest, BasicElement element, ResultRow row) {
        QuestEndType endType = row.getEnum(COLUMN_END_TYPE, QuestEndType.class);
        boolean showEndTitle = row.getBoolean(COLUMN_SHOW_END_TITLE);
        String endMessage = row.getString(COLUMN_END_MESSAGE);
        UUID outputId = row.getUuid(COLUMN_OUTPUT_ID);
        return new QuestEndElement(element.id(), element.name(), element.nameKey(), quest, endType, showEndTitle, endMessage, outputId);
    }

    private QuestWaitElement getWaitElementFromResultRow(Quest quest, BasicElement element, ResultRow row) {
        int inputsNeeded = row.getInt(COLUMN_INPUTS_NEEDED);
        return new QuestWaitElement(element.id(), element.name(), element.nameKey(), quest, inputsNeeded);
    }

    private QuestTimerElement getTimerElementFromResultRow(Quest quest, BasicElement element, ResultRow row) {
        long timerDuration = row.getLong(COLUMN_TIMER_DURATION);
        boolean silentTimer = row.getBoolean(COLUMN_SILENT_TIMER);
        return new QuestTimerElement(element.id(), element.name(), element.nameKey(), quest, timerDuration, silentTimer);
    }

    private QuestStopwatchElement getStopwatchElementFromResultRow(Quest quest, BasicElement element, ResultRow row) {
        boolean silentStopwatch = row.getBoolean(COLUMN_SILENT_STOPWATCH);
        return new QuestStopwatchElement(element.id(), element.name(), element.nameKey(), quest, silentStopwatch);
    }

    private QuestStartElement getStartElementFromResultRow(Quest quest, BasicElement element, ResultRow row) {
        Integer npcId = row.getNullableInt(COLUMN_NPC_ID);
        BlockCoordinate blockInteract = row.getNullableBlockCoordinate(COLUMN_BLOCK_INTERACT_COORDINATE);
        WorldArea locationReach = row.getNullableWorldArea(COLUMN_LOCATION_REACH_AREA);
        Date startTime = row.getNullableDate(COLUMN_START_TIME);
        Date endTime = row.getNullableDate(COLUMN_END_TIME);
        int xpRequired = row.getInt(COLUMN_XP_REQUIRED);
        boolean allowMultiplePlay = row.getBoolean(COLUMN_ALLOW_MULTIPLE_PLAY);
        int playCoolDownHours = row.getInt(COLUMN_PLAY_COOL_DOWN_HOURS);
        String preConditionScript = row.getNullableString(COLUMN_PRE_CONDITION_SCRIPT);
        DaysOfWeek playableDays = row.getDaysOfWeek(COLUMN_PLAYABLE_DAYS);
        QuestStartElement startElement = new QuestStartElement(element.id(), element.name(), element.nameKey(), quest, npcId, blockInteract, locationReach, startTime, endTime, xpRequired, allowMultiplePlay, playCoolDownHours, preConditionScript, playableDays);
        List<RequiredQuest> requiredQuests = this.getAllQuestsRequiredQuests(startElement);
        List<RequiredCharacter> requiredCharacters = this.getAllQuestsRequiredCharacters(startElement);
        startElement.setRequiredQuests(requiredQuests);
        startElement.setRequiredCharacters(requiredCharacters);
        return startElement;
    }

    private BasicObjective getBasicObjective(UUID id) {
        return Query.selectAllFrom("QUEST_OBJECTIVE").where(QueryColumn.column(COLUMN_ID, id)).getSingle(this::getBasicObjectiveFromResultRow).orElseThrow();
    }

    private BasicObjective getBasicObjectiveFromResultRow(ResultRow row) {
        String startMessage = row.getString(COLUMN_START_MESSAGE);
        String hint = row.getString(COLUMN_HINT);
        boolean silent = row.getBoolean(COLUMN_SILENT);
        boolean showTitle = row.getBoolean(COLUMN_SHOW_TITLE);
        boolean showOnCompass = row.getBoolean(COLUMN_SHOW_ON_COMPASS);
        return new BasicObjective(startMessage, hint, silent, showTitle, showOnCompass);
    }

    private void linkConversationElementOutputs(QuestElement questElement, List<QuestElementOutput> outputs) {
        if (questElement instanceof QuestConversationObjective) {
            QuestConversationObjective questConversationObjective = (QuestConversationObjective)questElement;
            for (QuestConversationElement conversationElement : questConversationObjective.getElements()) {
                for (QuestConversationElementOutput output : conversationElement.getOutputs()) {
                    QuestElementOutput targetOutput = outputs.stream().filter(o -> o.getId().equals(output.getElementOutputId())).findFirst().orElse(null);
                    output.setElementOutput(targetOutput);
                }
            }
        }
    }

    private void linkOutputLinksToElements(List<QuestElement> questElements) {
        for (QuestElement element : questElements) {
            for (QuestElementOutput output : element.getOutputs()) {
                for (QuestElementOutputLink link : output.getLinks()) {
                    QuestElement targetElement = questElements.stream().filter(e -> e.getId().equals(link.getTargetElementId())).findFirst().orElseThrow();
                    link.setTargetElement(targetElement);
                }
            }
        }
    }

    private BasicElement getBasicQuestElementFromResultRow(ResultRow row) {
        UUID id = row.getUuid(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String nameKey = row.getString(COLUMN_NAME_KEY);
        QuestElementType questElementType = row.getEnum(COLUMN_ELEMENT_TYPE, QuestElementType.class);
        return new BasicElement(id, name, nameKey, questElementType);
    }

    public List<QuestObjectiveBlockInteract> getAllBlockInteractsForObjective(QuestBlockInteractObjective objective) {
        return Query.selectAllFrom("QUEST_OBJECTIVE_BLOCK_INTERACT").where(QueryColumn.column(COLUMN_OBJECTIVE_ID, objective.getId())).getList(row -> this.getQuestObjectiveBlockInteractFromResultRow(row, objective));
    }

    private QuestObjectiveBlockInteract getQuestObjectiveBlockInteractFromResultRow(ResultRow row, QuestBlockInteractObjective objective) {
        UUID id = row.getUuid(COLUMN_ID);
        BlockCoordinate blockCoordinate = row.getBlockCoordinate(COLUMN_BLOCK_COORDINATE);
        String blockType = row.getNullableString(COLUMN_BLOCK_TYPE);
        boolean optional = row.getBoolean(COLUMN_OPTIONAL);
        String onCompleteScript = row.getNullableString(COLUMN_ON_COMPLETE_SCRIPT);
        return new QuestObjectiveBlockInteract(id, blockCoordinate, blockType, optional, onCompleteScript, objective);
    }

    public List<QuestFollowObjectiveWaypoint> getAllWaypointFollowsForObjective(QuestFollowNpcObjective objective) {
        return Query.selectAllFrom("QUEST_FOLLOW_OBJECTIVE_WAYPOINT").where(QueryColumn.column(COLUMN_OBJECTIVE_ID, objective.getId())).orderBy("WAYPOINT_ORDER ASC").getList(row -> this.getQuestFollowObjectiveWaypointFromResultRow(row, objective));
    }

    private QuestFollowObjectiveWaypoint getQuestFollowObjectiveWaypointFromResultRow(ResultRow row, QuestFollowNpcObjective objective) {
        UUID id = row.getUuid(COLUMN_ID);
        int waypointOrder = row.getInt(COLUMN_WAYPOINT_ORDER);
        Coordinate location = row.getCoordinate(COLUMN_LOCATION);
        double speed = row.getDouble(COLUMN_SPEED);
        return new QuestFollowObjectiveWaypoint(id, waypointOrder, location, speed, objective);
    }

    public List<QuestConversationElement> getAllConversationElementsForObjective(QuestConversationObjective objective) {
        List<BasicConversationElement> basicElementDetails = Query.selectAllFrom("QUEST_CONVERSATION_ELEMENT").where(QueryColumn.column(COLUMN_OBJECTIVE_ID, objective.getId())).getList(row -> this.getQuestConversationElementFromResultRow(row, objective));
        ArrayList<QuestConversationElement> conversationElements = new ArrayList<QuestConversationElement>(basicElementDetails.size());
        for (BasicConversationElement basicElement : basicElementDetails) {
            QuestConversationElement conversationElement;
            if (basicElement.type() == ConversationElementType.TEXT) {
                conversationElement = Query.selectAllFrom("QUEST_CONVERSATION_TEXT_ELEMENT").where(QueryColumn.column(COLUMN_ID, basicElement.id())).getSingle(row -> this.getQuestConversationTextElementFromResultRow(row, basicElement)).orElseThrow();
            } else if (basicElement.type() == ConversationElementType.PROMPT) {
                conversationElement = Query.selectAllFrom("QUEST_CONVERSATION_PROMPT_ELEMENT").where(QueryColumn.column(COLUMN_ID, basicElement.id())).getSingle(row -> this.getQuestConversationPromptElementFromResultRow(row, basicElement)).orElseThrow();
            } else if (basicElement.type() == ConversationElementType.SCRIPT) {
                conversationElement = Query.selectAllFrom("QUEST_CONVERSATION_SCRIPT_ELEMENT").where(QueryColumn.column(COLUMN_ID, basicElement.id())).getSingle(row -> this.getQuestConversationScriptElementFromResultRow(row, basicElement)).orElseThrow();
            } else {
                throw new IllegalArgumentException(String.format("Invalid element type: %s", basicElement.type().name()));
            }
            List<QuestConversationElementOutput> outputs = this.getOutputsForConversationElement(conversationElement);
            conversationElement.setOutputs(outputs);
            conversationElements.add(conversationElement);
        }
        return conversationElements;
    }

    private List<QuestConversationElementOutput> getOutputsForConversationElement(QuestConversationElement conversationElement) {
        return Query.selectAllFrom("QUEST_CONVERSATION_ELEMENT_OUTPUT").where(QueryColumn.column(COLUMN_CONVERSATION_ELEMENT_ID, conversationElement.getId())).getList(row -> this.getOutputFromResultRow(row, conversationElement));
    }

    private QuestConversationElementOutput getOutputFromResultRow(ResultRow row, QuestConversationElement conversationElement) {
        UUID id = row.getUuid(COLUMN_ID);
        QuestElementOutputType type = row.getEnum(COLUMN_OUTPUT_TYPE, QuestElementOutputType.class);
        String identifier = row.getString(COLUMN_IDENTIFIER);
        UUID nextConversationElementId = row.getNullableUuid(COLUMN_NEXT_CONVERSATION_ELEMENT_ID);
        UUID elementOutputId = row.getNullableUuid(COLUMN_ELEMENT_OUTPUT_ID);
        return new QuestConversationElementOutput(id, conversationElement, type, identifier, nextConversationElementId, elementOutputId);
    }

    private BasicConversationElement getQuestConversationElementFromResultRow(ResultRow row, QuestConversationObjective objective) {
        UUID id = row.getUuid(COLUMN_ID);
        ConversationElementType type = row.getEnum(COLUMN_CONVERSATION_ELEMENT_TYPE, ConversationElementType.class);
        boolean startingElement = row.getBoolean(COLUMN_STARTING_ELEMENT);
        return new BasicConversationElement(id, type, startingElement, objective);
    }

    private QuestConversationTextElement getQuestConversationTextElementFromResultRow(ResultRow row, BasicConversationElement elementDetails) {
        String npcWaitMessage = row.getString(COLUMN_NPC_WAIT_MESSAGE);
        QuestConversationTextElement textElement = new QuestConversationTextElement(elementDetails.id(), elementDetails.objective(), elementDetails.startingElement(), npcWaitMessage);
        List<QuestConversationTextElementLine> lines = this.getQuestConversationTextElementLinesForTextElement(textElement);
        textElement.setLines(lines);
        return textElement;
    }

    private List<QuestConversationTextElementLine> getQuestConversationTextElementLinesForTextElement(QuestConversationTextElement textElement) {
        return Query.selectAllFrom("QUEST_CONVERSATION_TEXT_ELEMENT_LINE").where(QueryColumn.column(COLUMN_TEXT_ELEMENT_ID, textElement.getId())).orderBy("DISPLAY_ORDER ASC").getList(row -> this.getQuestConversationTextElementLineFromResultRow(row, textElement));
    }

    private QuestConversationTextElementLine getQuestConversationTextElementLineFromResultRow(ResultRow row, QuestConversationTextElement textElement) {
        UUID id = row.getUuid(COLUMN_ID);
        String text = row.getString(COLUMN_TEXT);
        QuestConversationLineSpeaker lineSpeaker = row.getEnum(COLUMN_LINE_SPEAKER, QuestConversationLineSpeaker.class);
        Integer autoPlayNextSeconds = row.getNullableInt(COLUMN_AUTO_PLAY_NEXT_SECONDS);
        String npcWaitMessage = row.getString(COLUMN_NPC_WAIT_MESSAGE);
        QuestConversationTextElementLine line = new QuestConversationTextElementLine(id, textElement, text, lineSpeaker, autoPlayNextSeconds, npcWaitMessage);
        List<QuestConversationTextElementLineWaypoint> waypoints = this.getConversationWaypointsForConversationTextElementLine(line);
        line.setWaypoints(waypoints);
        return line;
    }

    private QuestConversationPromptElement getQuestConversationPromptElementFromResultRow(ResultRow row, BasicConversationElement elementDetails) {
        String title = row.getNullableString(COLUMN_TITLE);
        String text = row.getString(COLUMN_TEXT);
        QuestConversationPromptType type = row.getEnum(COLUMN_TYPE, QuestConversationPromptType.class);
        String promptScript = row.getNullableString(COLUMN_PROMPT_SCRIPT);
        String validationScript = row.getNullableString(COLUMN_VALIDATION_SCRIPT);
        String processingScript = row.getNullableString(COLUMN_PROCESSING_SCRIPT);
        QuestConversationPromptElement prompt = new QuestConversationPromptElement(elementDetails.id(), elementDetails.objective(), elementDetails.startingElement(), title, text, type, promptScript, validationScript, processingScript);
        List<QuestConversationPromptChoice> choices = type == QuestConversationPromptType.CHOICE ? this.getConversationPromptChoicesForPrompt(prompt) : Collections.emptyList();
        prompt.setChoices(choices);
        return prompt;
    }

    private QuestConversationScriptElement getQuestConversationScriptElementFromResultRow(ResultRow row, BasicConversationElement elementDetails) {
        String scriptText = row.getString(COLUMN_SCRIPT_TEXT);
        return new QuestConversationScriptElement(elementDetails.id(), elementDetails.objective(), elementDetails.startingElement(), scriptText);
    }

    private List<RequiredQuest> getAllQuestsRequiredQuests(QuestStartElement startElement) {
        return Query.selectAllFrom("QUEST_REQUIRED_QUEST").where(QueryColumn.column(COLUMN_START_ELEMENT_ID, startElement.getId())).getList(row -> this.getRequiredQuestFromResultRow(row, startElement));
    }

    private RequiredQuest getRequiredQuestFromResultRow(ResultRow row, QuestStartElement startElement) {
        int requiredQuestId = row.getInt(COLUMN_REQUIRED_QUEST_ID);
        UUID outputId = row.getNullableUuid(COLUMN_OUTPUT_ID);
        int hoursWait = row.getInt(COLUMN_HOURS_WAIT);
        return new RequiredQuest(startElement, requiredQuestId, outputId, hoursWait);
    }

    private List<RequiredCharacter> getAllQuestsRequiredCharacters(QuestStartElement startElement) {
        return Query.selectAllFrom("QUEST_REQUIRED_CHARACTER").where(QueryColumn.column(COLUMN_START_ELEMENT_ID, startElement.getId())).getList(row -> this.getRequiredCharacterFromResultRow(row, startElement));
    }

    private RequiredCharacter getRequiredCharacterFromResultRow(ResultRow row, QuestStartElement startElement) {
        int requiredCharacterId = row.getInt(COLUMN_REQUIRED_CHARACTER_ID);
        int hoursWait = row.getInt(COLUMN_HOURS_WAIT);
        Double minimumFriendship = row.getNullableDouble(COLUMN_MINIMUM_FRIENDSHIP);
        Double maximumFriendship = row.getNullableDouble(COLUMN_MAXIMUM_FRIENDSHIP);
        Range<Double> range = Range.of(minimumFriendship, maximumFriendship);
        return new RequiredCharacter(startElement, requiredCharacterId, hoursWait, range);
    }

    private List<QuestConversationPromptChoice> getConversationPromptChoicesForPrompt(QuestConversationPromptElement prompt) {
        return Query.selectAllFrom("QUEST_CONVERSATION_PROMPT_CHOICE").where(QueryColumn.column(COLUMN_PROMPT_ID, prompt.getId())).orderBy("DISPLAY_ORDER ASC").getList(row -> this.getQuestConversationPromptChoiceFromResultRow(row, prompt));
    }

    private QuestConversationPromptChoice getQuestConversationPromptChoiceFromResultRow(ResultRow row, QuestConversationPromptElement prompt) {
        int id = row.getInt(COLUMN_ID);
        String label = row.getString(COLUMN_LABEL);
        int displayOrder = row.getInt(COLUMN_DISPLAY_ORDER);
        UUID conversationElementOutputId = row.getNullableUuid(COLUMN_CONVERSATION_ELEMENT_OUTPUT_ID);
        return new QuestConversationPromptChoice(id, label, displayOrder, conversationElementOutputId, prompt);
    }

    private List<QuestConversationTextElementLineWaypoint> getConversationWaypointsForConversationTextElementLine(QuestConversationTextElementLine textElementLine) {
        return Query.selectAllFrom("QUEST_CONVERSATION_TEXT_ELEMENT_LINE_WAYPOINT").where(QueryColumn.column(COLUMN_LINE_ID, textElementLine.getId())).orderBy("WAYPOINT_ORDER ASC").getList(row -> this.getConversationWaypointFromResultRow(row, textElementLine));
    }

    private QuestConversationTextElementLineWaypoint getConversationWaypointFromResultRow(ResultRow row, QuestConversationTextElementLine textElementLine) {
        UUID id = row.getUuid(COLUMN_ID);
        int waypointOrder = row.getInt(COLUMN_WAYPOINT_ORDER);
        Coordinate location = row.getCoordinate(COLUMN_LOCATION);
        double speed = row.getDouble(COLUMN_SPEED);
        List<QuestWaypointAction> actions = this.getActionsForWaypoint(id);
        return new QuestConversationTextElementLineWaypoint(id, waypointOrder, location, speed, actions, textElementLine);
    }

    private List<QuestWaypointAction> getActionsForWaypoint(UUID waypointId) {
        return Query.selectAllFrom("QUEST_CONVERSATION_TEXT_ELEMENT_LINE_WAYPOINT_ACTION").where(QueryColumn.column(COLUMN_WAYPOINT_ID, waypointId)).getList(r -> r.getEnum(COLUMN_ACTION_NAME, QuestWaypointAction.class));
    }

    public List<QuestLocalPlaceholder> getLocalPlaceholdersForQuest(Quest quest) {
        return Query.selectAllFrom("QUEST_LOCAL_PLACEHOLDER").where(QueryColumn.column(COLUMN_QUEST_ID, quest.getId())).getList(r -> this.getQuestLocalPlaceholderFromResultRow(r, quest));
    }

    private QuestLocalPlaceholder getQuestLocalPlaceholderFromResultRow(ResultRow row, Quest quest) {
        String identifier = row.getString(COLUMN_IDENTIFIER);
        String script = row.getString(COLUMN_SCRIPT);
        return new QuestLocalPlaceholder(identifier, quest, script);
    }

    private record BasicElement(UUID id, String name, String nameKey, QuestElementType elementType) {
    }

    private record BasicObjective(String startMessage, String hint, boolean silent, boolean showTitle, boolean showOnCompass) {
    }

    private record BasicConversationElement(UUID id, ConversationElementType type, Boolean startingElement, QuestConversationObjective objective) {
    }

    private static enum ConversationElementType {
        TEXT,
        PROMPT,
        SCRIPT;

    }
}

