/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.entityload.EntityLoader;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestPlayersCache;
import com.equestricraft.core.quest.QuestRepository;
import com.equestricraft.core.quest.state.QuestPlayerStateSession;
import com.equestricraft.logging.Log;

public class QuestEntityLoader
implements EntityLoader {
    @Service
    private QuestRepository questRepository;
    @Service
    private QuestPlayerStateSession questPlayerStateSession;
    private final QuestPlayersCache questPlayersCache = QuestPlayersCache.getInstance();
    private static final Log log = Log.getLogger(QuestEntityLoader.class.getName());

    @Override
    public void load(String key) {
        int questId = Integer.parseInt(key);
        Quest existingQuest = (Quest)this.questRepository.findByKey(questId);
        this.questRepository.load(questId);
        if (existingQuest != null) {
            int playersReset = this.questPlayerStateSession.resetStateForQuestForAllPlayers(existingQuest);
            this.questPlayersCache.resetQuest(existingQuest);
            log.info("Loaded update for quest {}. Reset {} players", (Object)existingQuest.getName(), (Object)playersReset);
        }
    }

    @Override
    public String name() {
        return "quest";
    }
}

