/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.base.thread.ThreadChecker;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.ObjectUtils;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestPlaySession;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import com.equestricraft.logging.Log;
import java.util.Optional;
import java.util.function.Supplier;

public class QuestExecutor {
    @Service
    private static QuestPlaySession questPlaySession;
    private static final Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Optional<T> executeQuestTask(QuestPlayer player, Supplier<T> runnable2) {
        ThreadChecker.ensureNotServerThread();
        if (player.hasTrackedQuest() && player.tryLock()) {
            try {
                Optional<T> optional = Optional.ofNullable(runnable2.get());
                return optional;
            }
            catch (Exception ex) {
                String questName = ObjectUtils.nullable(player.getTrackedQuest(), Quest::getName, () -> "UNKNOWN");
                log.error(String.format("Error for %s in quest %s with message: %s", player.getIgn(), questName, ex.getMessage()), ex);
                QuestExecutor.abortQuest(player, ex.getMessage());
            }
            finally {
                player.unlock();
            }
        }
        return Optional.empty();
    }

    public static void executeAsyncQuestTask(QuestPlayer player, Runnable runnable2) {
        TaskScheduler.executeAsyncTask(() -> QuestExecutor.executeQuestTask(player, () -> {
            runnable2.run();
            return null;
        }));
    }

    private static void abortQuest(QuestPlayer questPlayer, String message) {
        try {
            questPlaySession.abortTrackedQuestWithError(questPlayer, message);
        }
        catch (Exception ex) {
            log.error(String.format("Error aborting quest for player %s. Quest should still have been abandoned", questPlayer.getIgn()), ex);
        }
    }

    private QuestExecutor() {
    }

    static {
        log = Log.getLogger(QuestExecutor.class.getName());
    }
}

