/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestDatabase;
import com.equestricraft.core.quest.QuestRepository;
import com.equestricraft.core.quest.log.QuestLogRepository;
import com.equestricraft.core.quest.placeholder.QuestGlobalPlaceholderRepository;
import com.equestricraft.core.quest.state.persisted.QuestPlayerStateRepository;
import com.equestricraft.core.quest.storygroup.QuestStoryGroupRepository;
import com.equestricraft.dataload.DataLoadModule;
import com.equestricraft.dataload.DataLoader;

public class QuestLoadService
implements DataLoader {
    @Service
    private QuestStoryGroupRepository questStoryGroupRepository;
    @Service
    private QuestRepository questRepository;
    @Service
    private QuestGlobalPlaceholderRepository questGlobalPlaceholderRepository;
    @Service
    private QuestLogRepository questLogRepository;
    @Service
    private QuestPlayerStateRepository questPlayerStateRepository;
    @Service
    private QuestDatabase questDatabase;

    @Override
    public void loadData() {
        this.questStoryGroupRepository.load();
        this.questGlobalPlaceholderRepository.load();
        this.questLogRepository.load();
        this.questPlayerStateRepository.load();
    }

    public void loadQuests() {
        this.questRepository.load();
    }

    @Override
    public DataLoadModule module() {
        return DataLoadModule.QUESTS;
    }

    public void loadRewardUpdate(Integer questId) {
        Quest quest = this.questDatabase.retrieveByKey(questId).orElseThrow();
        Quest existing = (Quest)this.questRepository.findByKey(questId);
        existing.setRewards(quest.getRewards());
    }
}

