/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest;

import com.equestricraft.base.eventbus.ECEventBus;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.npc.NPCResetForPlayerEvent;
import com.equestricraft.core.npc.NPCSetTempForPlayerEvent;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.quest.CannotPauseQuestException;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestException;
import com.equestricraft.core.quest.QuestPlaySession;
import com.equestricraft.core.quest.QuestPlayersCache;
import com.equestricraft.core.quest.QuestScriptSession;
import com.equestricraft.core.quest.element.QuestElement;
import com.equestricraft.core.quest.element.lifecycle.QuestElementLifecycle;
import com.equestricraft.core.quest.log.QuestLogSession;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import com.equestricraft.core.quest.state.PlayerQuestData;
import com.equestricraft.core.quest.state.PlayerQuestState;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyStandardScriptExecutor;
import com.equestricraft.logging.Log;
import java.util.UUID;

public class QuestPlaySessionImpl
implements QuestPlaySession {
    @Service
    private QuestLogSession questLogSession;
    @Service
    private QuestScriptSession questScriptSession;
    private final QuestPlayersCache questPlayersCache = QuestPlayersCache.getInstance();
    private static final Log log = Log.getLogger(QuestPlaySessionImpl.class.getName());

    @Override
    public void setTrackedQuest(QuestPlayer player, int questId) {
        PlayerQuestData data = player.getPlayerQuestData();
        data.setTrackedQuest(questId);
        PlayerQuestState trackedQuest = data.getTrackedQuestState();
        this.setQuestNPCs(player);
        trackedQuest.getActiveElementLifecycles().forEach(QuestElementLifecycle::resume);
        player.fireUpdate();
    }

    @Override
    public void pauseTrackedQuest(QuestPlayer player) throws CannotPauseQuestException {
        if (!player.getTrackedQuestState().allowPause()) {
            throw new CannotPauseQuestException(I18n.getLabel("quest.cannot-pause"));
        }
        PlayerQuestData data = player.getPlayerQuestData();
        data.stopTrackingCurrentQuest();
        this.resetNPCs(player);
        player.fireUpdate();
    }

    private void processFailedLog(ECPlayer player, Quest quest, UUID outputId) {
        if (quest.isLive()) {
            this.questLogSession.logQuestFailed(player.getCorePlayer(), quest, outputId, null, null);
        }
    }

    @Override
    public void abandonTrackedQuest(QuestPlayer player) {
        Quest quest = player.getTrackedQuest();
        try {
            this.abandonQuest(player, quest);
        }
        finally {
            this.clearQuestStateForPlayer(quest, player);
        }
    }

    @Override
    public void abandonQuest(QuestPlayer player, Quest quest) {
        log.info("Abandoning quest {} for {}", (Object)quest, (Object)player);
        this.executeOnAbandonScript(quest, player);
        player.sendTitle(I18n.getLabel(quest.getQuestType().getAbandonedTitleKey()), quest.getName());
        this.questPlayersCache.removePlayerFromPlayingQuest(quest, player);
        log.info("Abandoned quest {} for {}", (Object)quest, (Object)player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortTrackedQuestWithError(QuestPlayer player, String errorMessage) {
        Quest quest = player.getTrackedQuest();
        log.info("Aborting quest {} for {} with error: {}", quest, player, errorMessage);
        try {
            this.executeOnAbandonScript(quest, player);
            player.sendTitle(I18n.getLabel("quest.abort-error.title"), null);
            player.sendMessage(I18n.getLabel("quest.abort-error.message", errorMessage));
        }
        finally {
            this.clearQuestStateForPlayer(quest, player);
            this.questPlayersCache.removePlayerFromPlayingQuest(quest, player);
        }
        log.info("Aborted quest {} for {}", (Object)quest, (Object)player);
    }

    private void executeOnAbandonScript(Quest quest, QuestPlayer player) {
        if (quest.getOnAbandonScript() == null) {
            return;
        }
        try {
            GroovyStandardScriptExecutor executor = GroovyStandardScriptExecutor.start(quest.getOnAbandonScript());
            this.questScriptSession.initCoreVariables(executor, player);
            executor.execute();
        }
        catch (GroovyException ex) {
            log.error(String.format("Error running on abandon script for quest %s", quest.getId()), ex);
            throw new QuestException(ex);
        }
    }

    @Override
    public void completeQuest(QuestPlayer player, String completeMessage, UUID outputId, boolean showEndTitle) {
        Quest quest = player.getTrackedQuest();
        log.info("Completing quest {} for {}", (Object)quest, (Object)player);
        boolean hasPlayedBefore = this.questLogSession.hasPlayerCompletedQuest(player, quest.getId());
        this.processXpReward(player, quest, hasPlayedBefore);
        this.processMoneyReward(player, quest, hasPlayedBefore);
        this.processCompletedLog(player, quest, outputId);
        this.clearQuestStateForPlayer(quest, player);
        if (showEndTitle) {
            String message = completeMessage != null && !completeMessage.isBlank() ? completeMessage : quest.getName();
            player.sendTitle(I18n.getLabel(quest.getQuestType().getCompletedTitleKey()), message);
        }
        log.info("Completed quest {} for {}", (Object)quest, (Object)player);
    }

    private void processXpReward(QuestPlayer player, Quest quest, boolean hasPlayedBefore) {
        int xpReward;
        if (!quest.isLive()) {
            return;
        }
        PlayerQuestState questState = player.getTrackedQuestState();
        int n = xpReward = hasPlayedBefore ? questState.getReplayXpReward() : questState.getFirstXpReward();
        if (xpReward > 0) {
            player.getProgression().giveXp(xpReward);
        }
    }

    private void processMoneyReward(QuestPlayer player, Quest quest, boolean hasPlayedBefore) {
        double moneyReward;
        if (!quest.isLive()) {
            return;
        }
        PlayerQuestState questState = player.getTrackedQuestState();
        double d = moneyReward = hasPlayedBefore ? questState.getReplayMoneyReward() : questState.getFirstMoneyReward();
        if (moneyReward > 0.0) {
            player.getEconomy().deposit(moneyReward, I18n.getLabel("quest.money-reward.transaction", quest.getName()), "Quest");
        }
    }

    private void processCompletedLog(ECPlayer player, Quest quest, UUID outputId) {
        if (quest.isLive()) {
            this.questLogSession.logQuestCompleted(player.getCorePlayer(), quest, outputId, null, null);
        }
    }

    @Override
    public void failQuest(QuestPlayer player, String failMessage, UUID outputId, boolean showEndTitle) {
        Quest quest = player.getTrackedQuest();
        log.info("Failing quest {} for {}", (Object)quest, (Object)player);
        this.processFailedLog(player, quest, outputId);
        this.clearQuestStateForPlayer(quest, player);
        if (showEndTitle) {
            String message = failMessage != null && !failMessage.isBlank() ? failMessage : quest.getName();
            player.sendTitle(I18n.getLabel(quest.getQuestType().getFailedTitleKey()), message);
        }
        log.info("Failed quest {} for {}", (Object)quest, (Object)player);
    }

    @Override
    public void setQuestNPCs(QuestPlayer player) {
        NPCSetTempForPlayerEvent event = new NPCSetTempForPlayerEvent(player);
        ECEventBus.post(event);
    }

    @Override
    public void clearQuestStateForPlayer(Quest quest, QuestPlayer player) {
        this.removeQuest(player, quest);
        this.resetNPCs(player);
        player.getCompassManager().clearCompass();
        player.fireUpdate();
    }

    private void removeQuest(QuestPlayer player, Quest quest) {
        PlayerQuestState trackedQuest = player.getTrackedQuestState();
        trackedQuest.getActiveElementLifecycles().filter(QuestElementLifecycle::isActive).forEach(this::safeDeactivate);
        player.getPlayerQuestData().removeInProgressQuest(quest.getId());
        player.getLifecycleManager().process();
    }

    private void safeDeactivate(QuestElementLifecycle<QuestElement> l) {
        try {
            l.deactivate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void resetNPCs(QuestPlayer player) {
        NPCResetForPlayerEvent event = new NPCResetForPlayerEvent(player);
        ECEventBus.post(event);
    }
}

