/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.progression.PlayerProgressionMilestone;
import com.equestricraft.core.player.progression.PlayerProgressionMilestoneProvider;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestRepository;
import com.equestricraft.core.quest.element.QuestStartElement;
import com.equestricraft.core.quest.storygroup.QuestStoryGroup;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;

public class QuestPlayerProgressionMilestoneProvider
implements PlayerProgressionMilestoneProvider {
    @Service
    private QuestRepository questRepository;

    @Override
    public Stream<PlayerProgressionMilestone> getProgressionMilestones() {
        String defaultGroupName = I18n.getLabel("player.progression.milestone.type.quest");
        return this.questRepository.findQuestsForProgression().stream().map(q -> q.getTimeActiveStartingElements().min(Comparator.comparingInt(QuestStartElement::getXpRequired)).map(e -> {
            record QuestXpMap(Quest quest, int xp) {
            }
            return new QuestXpMap((Quest)q, e.getXpRequired());
        })).filter(Optional::isPresent).map(Optional::get).map(m -> {
            QuestStoryGroup storyGroup = m.quest().getStoryGroup();
            String groupName = storyGroup != null ? storyGroup.getName() : defaultGroupName;
            return new PlayerProgressionMilestone(m.quest().getName(), groupName, m.xp(), true);
        });
    }
}

