/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest;

import com.equestricraft.common.ListMap;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.quest.Quest;
import java.util.List;

public class QuestPlayersCache {
    private static final QuestPlayersCache instance = new QuestPlayersCache();
    private final ListMap<Integer, Integer> playerQuestMap = new ListMap();

    public static QuestPlayersCache getInstance() {
        return instance;
    }

    private QuestPlayersCache() {
    }

    public void setPlayerPlayingQuest(ECPlayer player, Quest quest) {
        this.playerQuestMap.add(quest.getId(), player.getId());
    }

    public List<Integer> getPlayersPlayingQuest(int questId) {
        return this.playerQuestMap.get(questId);
    }

    public void removePlayerFromPlayingQuest(Quest quest, ECPlayer player) {
        this.playerQuestMap.remove(quest.getId(), player.getId());
    }

    public void resetQuest(Quest quest) {
        this.playerQuestMap.clear(quest.getId());
    }
}

