/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.QuestType;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestDatabase;
import java.util.List;

public class QuestRepository
extends Repository<Quest, Integer> {
    @Service
    private QuestDatabase questDatabase;

    @Override
    protected RepositoryDatasource<Quest, Integer> getDatasource() {
        return this.questDatabase;
    }

    public List<Quest> findActiveQuestsByStoryGroup(int storyGroupId) {
        RepositorySearchQuery<Quest> searchQuery = this.createSearchQuery();
        searchQuery.filterNot(Quest::isArchived);
        searchQuery.filter(q -> q.getQuestStoryGroupId() != null && q.getQuestStoryGroupId() == storyGroupId);
        return searchQuery.many();
    }

    public List<Quest> findActiveQuestsByStoryGroupAndType(int storyGroupId, QuestType questType) {
        RepositorySearchQuery<Quest> searchQuery = this.createSearchQuery();
        searchQuery.filterNot(Quest::isArchived);
        searchQuery.filter(q -> q.getQuestType() == questType);
        searchQuery.filter(q -> q.getQuestStoryGroupId() != null && q.getQuestStoryGroupId() == storyGroupId);
        return searchQuery.many();
    }

    public List<Quest> findActiveQuestsNotInAnyStoryGroupByType(QuestType questType) {
        RepositorySearchQuery<Quest> searchQuery = this.createSearchQuery();
        searchQuery.filterNot(Quest::isArchived);
        searchQuery.filter(q -> q.getQuestType() == questType);
        searchQuery.filter(q -> q.getQuestStoryGroupId() == null);
        return searchQuery.many();
    }

    public List<Quest> findActiveQuests() {
        RepositorySearchQuery<Quest> searchQuery = this.createSearchQuery();
        searchQuery.filterNot(Quest::isArchived);
        return searchQuery.many();
    }

    public List<Quest> findQuestsAsAchievements() {
        RepositorySearchQuery<Quest> searchQuery = this.createSearchQuery();
        searchQuery.filter(Quest::isAchievement);
        searchQuery.filter(Quest::isLive);
        return searchQuery.many();
    }

    public List<Quest> findQuestsForProgression() {
        RepositorySearchQuery<Quest> searchQuery = this.createSearchQuery();
        searchQuery.filter(Quest::isShowOnProgression);
        searchQuery.filter(Quest::isLive);
        return searchQuery.many();
    }
}

