/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest;

import com.equestricraft.base.worldarea.WorldArea;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.core.npc.NPC;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestRepository;
import com.equestricraft.core.quest.QuestStartConditionSession;
import com.equestricraft.core.quest.QuestStartDetails;
import com.equestricraft.core.quest.element.QuestStartElement;
import com.equestricraft.core.quest.requirementcheck.QuestRequirementCheckSession;
import com.equestricraft.core.quest.requirementcheck.response.QuestRequirementCheckResponse;
import java.awt.geom.Point2D;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;

public class QuestStartConditionSessionImpl
implements QuestStartConditionSession {
    @Service
    private QuestRepository questRepository;
    @Service
    private QuestRequirementCheckSession questRequirementCheckSession;

    @Override
    public QuestStartDetails findBlankStarterForQuest(ECPlayer player, Quest quest) {
        CanPlayCheck canPlayCheck = this.canPlayerPlayQuest(player, quest);
        return new QuestStartDetails(quest, canPlayCheck.canPlay, canPlayCheck.showOnMenu, canPlayCheck.blankStarter);
    }

    private CanPlayCheck canPlayerPlayQuest(ECPlayer player, Quest quest) {
        return quest.getTimeActiveStartingElements().map(e -> new RequirementResponsePair((QuestStartElement)e, this.questRequirementCheckSession.doesPlayerMeetQuestRequirements(player, (QuestStartElement)e))).collect(QuestStartConditionSessionImpl.combineRequirementChecks());
    }

    @Override
    public Optional<QuestStartDetails> findQuestWithStartingLocation(ECPlayer player, Coordinate coordinate) {
        Point2D.Double point = new Point2D.Double(coordinate.x(), coordinate.z());
        Stream<QuestStartDetails> starters = this.findMatchingQuests(player, e -> {
            WorldArea locationReachArea = e.getLocationReachArea();
            return locationReachArea != null && locationReachArea.getDimension().getIdentifier().equals(coordinate.world()) && locationReachArea.getRangeY().containsValueWithin((int)coordinate.y()) && locationReachArea.getArea().contains(point);
        });
        return starters.findFirst();
    }

    @Override
    public Stream<QuestStartDetails> findQuestsWithStartingNpc(ECPlayer player, NPC npc) {
        return this.findMatchingQuests(player, e -> e.getNpcId() != null && e.getNpc().equals(npc));
    }

    @Override
    public Stream<QuestStartDetails> findQuestsForBlockCoordinate(ECPlayer player, BlockCoordinate coordinate) {
        return this.findMatchingQuests(player, e -> e.getBlockInteract() != null && e.getBlockInteract().equals(coordinate));
    }

    private Stream<QuestStartDetails> findMatchingQuests(ECPlayer player, Predicate<QuestStartElement> predicate) {
        return this.questRepository.findActiveQuests().stream().map(quest -> quest.getTimeActiveStartingElements().filter(predicate).filter(e -> this.questRequirementCheckSession.canPlayerPlayQuest(player, (QuestStartElement)e)).findFirst().map(e -> new QuestStartDetails((Quest)quest, true, true, (QuestStartElement)e))).filter(Optional::isPresent).map(Optional::get);
    }

    private static Collector<RequirementResponsePair, CanPlayCheck, CanPlayCheck> combineRequirementChecks() {
        return Collector.of(CanPlayCheck::new, CanPlayCheck::apply, CanPlayCheck::merge, new Collector.Characteristics[0]);
    }

    private static class CanPlayCheck {
        private boolean canPlay = false;
        private boolean showOnMenu = false;
        private QuestStartElement blankStarter;

        CanPlayCheck() {
        }

        CanPlayCheck(boolean canPlay, boolean showOnMenu, QuestStartElement blankStarter) {
            this.canPlay = canPlay;
            this.showOnMenu = showOnMenu;
            this.blankStarter = blankStarter;
        }

        void apply(RequirementResponsePair pair) {
            if (pair.response().canPlay()) {
                this.canPlay = true;
            }
            if (pair.response().mayShowOnMenu()) {
                this.showOnMenu = true;
            }
            if (pair.startElement().isBlankStarter()) {
                this.blankStarter = pair.startElement();
            }
        }

        CanPlayCheck merge(CanPlayCheck other) {
            return new CanPlayCheck(this.canPlay || other.canPlay, this.showOnMenu || other.showOnMenu, this.blankStarter != null ? this.blankStarter : other.blankStarter);
        }
    }

    private record RequirementResponsePair(QuestStartElement startElement, QuestRequirementCheckResponse response) {
    }
}

