/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.quest.CannotStartQuestException;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestPlaySession;
import com.equestricraft.core.quest.QuestPlayersCache;
import com.equestricraft.core.quest.QuestStartSession;
import com.equestricraft.core.quest.element.QuestStartElement;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import com.equestricraft.core.quest.requirementcheck.QuestRequirementCheckSession;
import com.equestricraft.core.quest.requirementcheck.response.QuestRequirementCheckResponse;
import com.equestricraft.core.quest.state.PlayerQuestData;
import com.equestricraft.core.quest.state.PlayerQuestState;
import com.equestricraft.logging.Log;

public class QuestStartSessionImpl
implements QuestStartSession {
    @Service
    private QuestPlaySession questPlaySession;
    @Service
    private QuestRequirementCheckSession questRequirementCheckSession;
    private final QuestPlayersCache questPlayersCache = QuestPlayersCache.getInstance();
    private static final Log log = Log.getLogger(QuestStartSessionImpl.class.getName());

    @Override
    public void startQuest(QuestPlayer player, Quest quest, QuestStartElement startElement) throws CannotStartQuestException {
        QuestRequirementCheckResponse requirementCheckResponse = this.questRequirementCheckSession.doesPlayerMeetQuestRequirements(player, startElement);
        if (requirementCheckResponse.cannotPlay()) {
            throw new CannotStartQuestException(requirementCheckResponse.message());
        }
        if (player.isQuestInProgress(quest.getId())) {
            throw new CannotStartQuestException(I18n.getLabel("quest.already-in-progress-quest"));
        }
        this.trackNewQuest(player, quest, startElement);
        this.questPlayersCache.setPlayerPlayingQuest(player, quest);
        try {
            if (quest.isShowStartTitle()) {
                if (quest.getCustomStartTitleText() != null) {
                    player.sendTitle(quest.getCustomStartTitleText(), null);
                } else {
                    player.sendTitle(I18n.getLabel(quest.getQuestType().getStartedTitleKey()), quest.getName());
                }
            }
            this.questPlaySession.setQuestNPCs(player);
        }
        catch (Exception ex) {
            log.error(String.format("Error starting quest %s", quest.getId()), ex);
            this.questPlaySession.abortTrackedQuestWithError(player, ex.getMessage());
        }
    }

    private void trackNewQuest(QuestPlayer player, Quest quest, QuestStartElement startElement) {
        PlayerQuestData data = player.getPlayerQuestData();
        PlayerQuestState newQuestState = new PlayerQuestState(player, quest);
        data.addQuestStateToInProgress(newQuestState);
        data.setTrackedQuest(quest.getId());
        TaskScheduler.executeAsyncTask(() -> {
            try {
                startElement.getLifecycle(player).activate();
                player.getLifecycleManager().process();
            }
            catch (Exception ex) {
                log.error(String.format("Error executing start element %s for quest %s", startElement.getNameKey(), quest), ex);
                this.questPlaySession.abortTrackedQuestWithError(player, ex.getMessage());
            }
        });
    }
}

