/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest;

import com.equestricraft.api.common.APIActiveQuestDto;
import com.equestricraft.api.common.APIActiveQuestObjectiveDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.interpolation.AbstractPlayerStringInterpolator;
import com.equestricraft.core.quest.QuestTransformer;
import com.equestricraft.core.quest.element.lifecycle.QuestObjectiveElementLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import com.equestricraft.core.quest.state.PlayerQuestState;
import java.util.Map;

public class QuestStringInterpolator
extends AbstractPlayerStringInterpolator<QuestPlayer> {
    @Service
    private static QuestTransformer questTransformer;
    private final QuestObjectiveElementLifecycle<?> objectiveLifecycle;

    public QuestStringInterpolator(QuestPlayer player, QuestObjectiveElementLifecycle<?> objectiveLifecycle) {
        super(player);
        this.objectiveLifecycle = objectiveLifecycle;
    }

    public QuestStringInterpolator(QuestPlayer player) {
        this(player, null);
    }

    @Override
    protected void addAdditionalVariables(Map<String, Object> rootVariables) {
        if (((QuestPlayer)this.player).hasTrackedQuest()) {
            PlayerQuestState trackedQuestState = ((QuestPlayer)this.player).getTrackedQuestState();
            APIActiveQuestDto questStateDto = questTransformer.toDto(trackedQuestState);
            rootVariables.put("quest", questStateDto);
            if (this.objectiveLifecycle != null) {
                APIActiveQuestObjectiveDto objectiveDto = questTransformer.toDto(this.objectiveLifecycle);
                rootVariables.put("objective", objectiveDto);
            }
            Map<String, Object> sessionData = trackedQuestState.getGroovyScriptSessionData().immutableMap();
            rootVariables.put("variable", sessionData);
            rootVariables.put("sessionData", sessionData);
            rootVariables.put("session", sessionData);
        }
    }
}

