/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest;

import com.equestricraft.api.common.APIActiveQuestDto;
import com.equestricraft.api.common.APIActiveQuestObjectiveDto;
import com.equestricraft.api.common.APINpcDto;
import com.equestricraft.core.npc.APINpcDtoImpl;
import com.equestricraft.core.npc.NPC;
import com.equestricraft.core.quest.api.APIActiveQuestDtoImpl;
import com.equestricraft.core.quest.api.APIActiveQuestObjectiveDtoImpl;
import com.equestricraft.core.quest.element.QuestConversationObjective;
import com.equestricraft.core.quest.element.QuestFollowNpcObjective;
import com.equestricraft.core.quest.element.QuestObjective;
import com.equestricraft.core.quest.element.lifecycle.QuestObjectiveElementLifecycle;
import com.equestricraft.core.quest.state.PlayerQuestState;

public class QuestTransformer {
    public APIActiveQuestDto toDto(PlayerQuestState state) {
        return new APIActiveQuestDtoImpl(state);
    }

    public APIActiveQuestObjectiveDto toDto(QuestObjectiveElementLifecycle<?> objectiveLifecycle) {
        APINpcDto npcDto = this.getNpc((QuestObjective)objectiveLifecycle.getElement());
        return new APIActiveQuestObjectiveDtoImpl(objectiveLifecycle.getName(), npcDto);
    }

    private APINpcDto getNpc(QuestObjective questObjective) {
        if (questObjective instanceof QuestConversationObjective) {
            QuestConversationObjective conversationObjective = (QuestConversationObjective)questObjective;
            NPC npc = conversationObjective.getNpc();
            return npc != null ? new APINpcDtoImpl(npc) : null;
        }
        if (questObjective instanceof QuestFollowNpcObjective) {
            QuestFollowNpcObjective followNpcObjective = (QuestFollowNpcObjective)questObjective;
            NPC npc = followNpcObjective.getNpc();
            return npc != null ? new APINpcDtoImpl(npc) : null;
        }
        return null;
    }
}

