/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.CachedValue;
import com.equestricraft.common.Range;
import com.equestricraft.core.character.CharacterProfile;
import com.equestricraft.core.character.CharacterProfileRepository;
import com.equestricraft.core.quest.element.QuestStartElement;

public class RequiredCharacter {
    private final QuestStartElement startElement;
    private final int requiredCharacterId;
    private final int hoursWait;
    private final Range<Double> friendshipPercentage;
    @Service
    private static CharacterProfileRepository characterProfileRepository;
    private final CachedValue<CharacterProfile> character = CachedValue.build(() -> (CharacterProfile)characterProfileRepository.findByKey(this.getRequiredCharacterId())).expiredIfOlderThanDuration(characterProfileRepository::getDurationSinceLastLoad).complete();

    public RequiredCharacter(QuestStartElement startElement, int requiredCharacterId, int hoursWait, Range<Double> friendshipPercentage) {
        this.startElement = startElement;
        this.requiredCharacterId = requiredCharacterId;
        this.hoursWait = hoursWait;
        this.friendshipPercentage = friendshipPercentage;
    }

    public QuestStartElement getStartElement() {
        return this.startElement;
    }

    public int getRequiredCharacterId() {
        return this.requiredCharacterId;
    }

    public CharacterProfile getCharacter() {
        return this.character.get();
    }

    public int getHoursWait() {
        return this.hoursWait;
    }

    public Range<Double> getFriendshipPercentage() {
        return this.friendshipPercentage;
    }
}

