/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.api;

import com.equestricraft.api.common.APIActiveQuestDto;
import com.equestricraft.api.common.APIActiveQuestObjectivesDto;
import com.equestricraft.api.common.APIActiveQuestStopwatchesDto;
import com.equestricraft.api.common.APIActiveQuestTimersDto;
import com.equestricraft.api.common.APIMoneyValueDto;
import com.equestricraft.api.common.APIQuestStartTimeDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.economy.EconomyTransformer;
import com.equestricraft.core.quest.api.APIActiveQuestObjectivesDtoImpl;
import com.equestricraft.core.quest.api.APIActiveQuestStopwatchesDtoImpl;
import com.equestricraft.core.quest.api.APIActiveQuestTimersDtoImpl;
import com.equestricraft.core.quest.api.APIQuestStartTimeDtoImpl;
import com.equestricraft.core.quest.state.PlayerQuestState;

public class APIActiveQuestDtoImpl
implements APIActiveQuestDto {
    private final PlayerQuestState playerQuestState;
    @Service
    private static EconomyTransformer economyTransformer;

    public APIActiveQuestDtoImpl(PlayerQuestState playerQuestState) {
        this.playerQuestState = playerQuestState;
    }

    @Override
    public String getName() {
        return this.playerQuestState.getQuest().getName();
    }

    @Override
    public APIQuestStartTimeDto getStartTime() {
        return new APIQuestStartTimeDtoImpl(this.playerQuestState.getStartTime());
    }

    @Override
    public APIActiveQuestStopwatchesDto getStopwatches() {
        return new APIActiveQuestStopwatchesDtoImpl(this.playerQuestState.getStopwatches());
    }

    @Override
    public APIActiveQuestTimersDto getTimers() {
        return new APIActiveQuestTimersDtoImpl(this.playerQuestState.getTimers());
    }

    @Override
    public Integer getFirstXpReward() {
        return this.playerQuestState.getFirstXpReward();
    }

    @Override
    public void setFirstXpReward(Integer xp) {
        this.playerQuestState.setFirstXpReward(xp);
    }

    @Override
    public Integer getReplayXpReward() {
        return this.playerQuestState.getReplayXpReward();
    }

    @Override
    public void setReplayXpReward(Integer xp) {
        this.playerQuestState.setReplayXpReward(xp);
    }

    @Override
    public APIMoneyValueDto getFirstMoneyReward() {
        return economyTransformer.toApiDto(this.playerQuestState.getFirstMoneyReward());
    }

    @Override
    public void setFirstMoneyReward(Object money) {
        if (money instanceof Number) {
            Number number = (Number)money;
            this.playerQuestState.setFirstMoneyReward(number.doubleValue());
        } else if (money instanceof APIMoneyValueDto) {
            APIMoneyValueDto apiMoneyValueDto = (APIMoneyValueDto)money;
            this.playerQuestState.setReplayMoneyReward(apiMoneyValueDto.getValue());
        } else {
            throw new IllegalArgumentException(String.format("Invalid money value: %s", money.toString()));
        }
    }

    @Override
    public APIMoneyValueDto getReplayMoneyReward() {
        return economyTransformer.toApiDto(this.playerQuestState.getReplayMoneyReward());
    }

    @Override
    public void setReplayMoneyReward(Object money) {
        if (money instanceof Number) {
            Number number = (Number)money;
            this.playerQuestState.setReplayMoneyReward(number.doubleValue());
        } else if (money instanceof APIMoneyValueDto) {
            APIMoneyValueDto apiMoneyValueDto = (APIMoneyValueDto)money;
            this.playerQuestState.setReplayMoneyReward(apiMoneyValueDto.getValue());
        } else {
            throw new IllegalArgumentException(String.format("Invalid money value: %s", money.toString()));
        }
    }

    @Override
    public APIActiveQuestObjectivesDto getObjectives() {
        return new APIActiveQuestObjectivesDtoImpl(this.playerQuestState);
    }
}

