/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.api;

import com.equestricraft.api.common.APIActiveQuestObjectiveDto;
import com.equestricraft.api.common.APIActiveQuestObjectivesDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.MapAdapter;
import com.equestricraft.core.quest.QuestTransformer;
import com.equestricraft.core.quest.element.QuestObjective;
import com.equestricraft.core.quest.element.lifecycle.QuestObjectiveElementLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import com.equestricraft.core.quest.state.PlayerQuestState;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class APIActiveQuestObjectivesDtoImpl
extends MapAdapter<String, APIActiveQuestObjectiveDto>
implements APIActiveQuestObjectivesDto {
    private final QuestPlayer player;
    private final List<QuestObjective> objectives;
    @Service
    private static QuestTransformer questTransformer;

    public APIActiveQuestObjectivesDtoImpl(PlayerQuestState playerQuestState) {
        this.player = playerQuestState.getPlayer();
        this.objectives = playerQuestState.getQuest().getElements().stream().filter(QuestObjective.class::isInstance).map(QuestObjective.class::cast).toList();
    }

    @Override
    public int size() {
        return this.objectives.size();
    }

    @Override
    public APIActiveQuestObjectiveDto get(Object nameKey) {
        return this.objectives.stream().filter(o -> o.getNameKey().equals(nameKey)).map(o -> o.getLifecycle(this.player)).map(questTransformer::toDto).findFirst().orElse(null);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.objectives.stream().anyMatch(o -> o.getNameKey().equals(key));
    }

    @Override
    public Set<Map.Entry<String, APIActiveQuestObjectiveDto>> entrySet() {
        return new EntrySet();
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<String, APIActiveQuestObjectiveDto>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, APIActiveQuestObjectiveDto>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return APIActiveQuestObjectivesDtoImpl.this.objectives.size();
        }

        final class EntrySetIterator
        implements Iterator<Map.Entry<String, APIActiveQuestObjectiveDto>> {
            private int currentIndex = 0;

            EntrySetIterator() {
            }

            @Override
            public boolean hasNext() {
                return EntrySet.this.size() > this.currentIndex;
            }

            @Override
            public Map.Entry<String, APIActiveQuestObjectiveDto> next() {
                if (this.hasNext()) {
                    QuestObjective objective = APIActiveQuestObjectivesDtoImpl.this.objectives.get(this.currentIndex++);
                    APIActiveQuestObjectiveDto dto = questTransformer.toDto((QuestObjectiveElementLifecycle<?>)objective.getLifecycle(APIActiveQuestObjectivesDtoImpl.this.player));
                    return Map.entry(objective.getNameKey(), dto);
                }
                throw new NoSuchElementException();
            }
        }
    }
}

