/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.api;

import com.equestricraft.api.common.APIActiveQuestTimerDto;
import com.equestricraft.api.common.APIActiveQuestTimersDto;
import com.equestricraft.common.MapAdapter;
import com.equestricraft.core.quest.api.APIActiveQuestTimerDtoImpl;
import com.equestricraft.core.quest.state.ActiveQuestTimer;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class APIActiveQuestTimersDtoImpl
extends MapAdapter<String, APIActiveQuestTimerDto>
implements APIActiveQuestTimersDto {
    private final Map<String, ActiveQuestTimer> timers;

    public APIActiveQuestTimersDtoImpl(Map<String, ActiveQuestTimer> timers) {
        this.timers = timers;
    }

    @Override
    public int size() {
        return this.timers.size();
    }

    @Override
    public APIActiveQuestTimerDto get(Object identifier) {
        ActiveQuestTimer timer = this.timers.get(identifier);
        return new APIActiveQuestTimerDtoImpl(timer);
    }

    @Override
    public Set<Map.Entry<String, APIActiveQuestTimerDto>> entrySet() {
        return new EntrySet();
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<String, APIActiveQuestTimerDto>> {
        private final List<APIActiveQuestTimerDto> backedList;

        public EntrySet() {
            this.backedList = APIActiveQuestTimersDtoImpl.this.timers.values().stream().map(t -> new APIActiveQuestTimerDtoImpl((ActiveQuestTimer)t)).toList();
        }

        @Override
        public Iterator<Map.Entry<String, APIActiveQuestTimerDto>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return this.backedList.size();
        }

        final class EntrySetIterator
        implements Iterator<Map.Entry<String, APIActiveQuestTimerDto>> {
            private int currentIndex = 0;

            EntrySetIterator() {
            }

            @Override
            public boolean hasNext() {
                return EntrySet.this.size() > this.currentIndex;
            }

            @Override
            public Map.Entry<String, APIActiveQuestTimerDto> next() {
                if (this.hasNext()) {
                    APIActiveQuestTimerDto timer = EntrySet.this.backedList.get(this.currentIndex++);
                    return Map.entry(timer.getIdentifier(), timer);
                }
                throw new NoSuchElementException();
            }
        }
    }
}

