/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element;

import com.equestricraft.common.QuestElementType;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestObjectiveBlockInteract;
import com.equestricraft.core.quest.element.QuestObjective;
import com.equestricraft.core.quest.element.lifecycle.QuestBlockInteractObjectiveLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.util.List;
import java.util.UUID;

public class QuestBlockInteractObjective
extends QuestObjective {
    private final Integer requiredOptionalBlockInteracts;
    private List<QuestObjectiveBlockInteract> blockInteracts;

    public QuestBlockInteractObjective(UUID id, String name, String nameKey, Quest quest, String startMessage, String hint, boolean silent, boolean showTitle, boolean showOnCompass, Integer requiredOptionalBlockInteracts) {
        super(id, name, nameKey, quest, startMessage, hint, silent, showTitle, showOnCompass);
        this.requiredOptionalBlockInteracts = requiredOptionalBlockInteracts;
    }

    public Integer getRequiredOptionalBlockInteracts() {
        return this.requiredOptionalBlockInteracts;
    }

    public List<QuestObjectiveBlockInteract> getBlockInteracts() {
        return this.blockInteracts;
    }

    public QuestObjectiveBlockInteract getBlockInteractForBlockCoordinate(BlockCoordinate blockCoordinate) {
        return this.getBlockInteracts().stream().filter(b -> b.getBlockCoordinate().equals(blockCoordinate)).findFirst().orElseThrow();
    }

    public void setBlockInteracts(List<QuestObjectiveBlockInteract> blockInteracts) {
        this.blockInteracts = blockInteracts;
    }

    @Override
    public QuestElementType getQuestElementType() {
        return QuestElementType.BLOCK_INTERACT;
    }

    @Override
    public QuestBlockInteractObjectiveLifecycle getLifecycle(QuestPlayer player) {
        return (QuestBlockInteractObjectiveLifecycle)player.getTrackedQuestState().requireElementLifecycle(this);
    }

    @Override
    public QuestBlockInteractObjectiveLifecycle getNewLifecycle(QuestPlayer player) {
        return new QuestBlockInteractObjectiveLifecycle(this, player);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

