/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.CachedValue;
import com.equestricraft.common.QuestElementType;
import com.equestricraft.core.npc.NPC;
import com.equestricraft.core.npc.NPCRepository;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.element.QuestObjective;
import com.equestricraft.core.quest.element.conversation.QuestConversationElement;
import com.equestricraft.core.quest.element.lifecycle.QuestConversationObjectiveLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.util.List;
import java.util.UUID;

public class QuestConversationObjective
extends QuestObjective {
    private final Integer npcId;
    private final boolean playFirstElement;
    private List<QuestConversationElement> elements;
    @Service
    private static NPCRepository npcRepository;
    private final CachedValue<NPC> npc = CachedValue.build(() -> (NPC)npcRepository.findByKey(this.getNpcId())).expiredIfOlderThanDuration(npcRepository::getDurationSinceLastLoad).complete();

    public QuestConversationObjective(UUID id, String name, String nameKey, Quest quest, String startMessage, String hint, boolean silent, boolean showTitle, boolean showOnCompass, Integer npcId, boolean playFirstElement) {
        super(id, name, nameKey, quest, startMessage, hint, silent, showTitle, showOnCompass);
        this.npcId = npcId;
        this.playFirstElement = playFirstElement;
    }

    public Integer getNpcId() {
        return this.npcId;
    }

    public NPC getNpc() {
        return this.npc.get();
    }

    public boolean isPlayFirstElement() {
        return this.playFirstElement;
    }

    public List<QuestConversationElement> getElements() {
        return this.elements;
    }

    public QuestConversationElement getElementById(UUID id) {
        return this.getElements().stream().filter(e -> e.getId().equals(id)).findFirst().orElseThrow();
    }

    public QuestConversationElement getFirstElement() {
        return this.getElements().stream().filter(QuestConversationElement::isStartingElement).findFirst().orElseThrow();
    }

    public void setElements(List<QuestConversationElement> elements) {
        this.elements = elements;
    }

    @Override
    public QuestElementType getQuestElementType() {
        return QuestElementType.CONVERSATION;
    }

    @Override
    public QuestConversationObjectiveLifecycle getLifecycle(QuestPlayer player) {
        return (QuestConversationObjectiveLifecycle)player.getTrackedQuestState().requireElementLifecycle(this);
    }

    @Override
    public QuestConversationObjectiveLifecycle getNewLifecycle(QuestPlayer player) {
        return new QuestConversationObjectiveLifecycle(this, player);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

