/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element;

import com.equestricraft.common.QuestElementOutputType;
import com.equestricraft.common.QuestElementType;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestComponent;
import com.equestricraft.core.quest.element.QuestElementOutput;
import com.equestricraft.core.quest.element.lifecycle.QuestElementLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public abstract class QuestElement
implements QuestComponent<QuestElement> {
    private final UUID id;
    private final String name;
    private final String nameKey;
    private final Quest quest;
    private List<QuestElementOutput> outputs;

    QuestElement(UUID id, String name, String nameKey, Quest quest) {
        this.id = id;
        this.name = name;
        this.nameKey = nameKey;
        this.quest = quest;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNameKey() {
        return this.nameKey;
    }

    @Override
    public Quest getQuest() {
        return this.quest;
    }

    public List<QuestElementOutput> getOutputs() {
        return this.outputs;
    }

    public QuestElementOutput getOutputByIdentifier(String identifier) {
        return this.getOutputs().stream().filter(o -> o.getIdentifier().equals(identifier)).findFirst().orElseThrow();
    }

    public QuestElementOutput getOutputByType(QuestElementOutputType type) {
        return this.getOutputs().stream().filter(o -> o.getType().equals((Object)type)).findFirst().orElseThrow();
    }

    public void setOutputs(List<QuestElementOutput> outputs) {
        this.outputs = outputs;
    }

    public abstract QuestElementType getQuestElementType();

    @Override
    public QuestElement getElement() {
        return this;
    }

    public abstract QuestElementLifecycle<?> getLifecycle(QuestPlayer var1);

    public abstract QuestElementLifecycle<?> getNewLifecycle(QuestPlayer var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuestElement that = (QuestElement)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.quest.toString() + " > " + this.nameKey;
    }
}

