/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element;

import com.equestricraft.common.QuestElementType;
import com.equestricraft.common.QuestEndType;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.element.QuestElement;
import com.equestricraft.core.quest.element.lifecycle.QuestEndElementLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.util.UUID;

public class QuestEndElement
extends QuestElement {
    private final QuestEndType endType;
    private final boolean showEndTitle;
    private final String endMessage;
    private final UUID outputId;

    public QuestEndElement(UUID id, String name, String nameKey, Quest quest, QuestEndType endType, boolean showEndTitle, String endMessage, UUID outputId) {
        super(id, name, nameKey, quest);
        this.endType = endType;
        this.showEndTitle = showEndTitle;
        this.endMessage = endMessage;
        this.outputId = outputId;
    }

    public QuestEndType getEndType() {
        return this.endType;
    }

    public boolean isShowEndTitle() {
        return this.showEndTitle;
    }

    public String getEndMessage() {
        return this.endMessage;
    }

    public UUID getOutputId() {
        return this.outputId;
    }

    @Override
    public QuestElementType getQuestElementType() {
        return QuestElementType.END_QUEST;
    }

    public QuestEndElementLifecycle getLifecycle(QuestPlayer player) {
        return (QuestEndElementLifecycle)player.getTrackedQuestState().requireElementLifecycle(this);
    }

    public QuestEndElementLifecycle getNewLifecycle(QuestPlayer player) {
        return new QuestEndElementLifecycle(this, player);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

