/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.CachedValue;
import com.equestricraft.common.QuestElementType;
import com.equestricraft.core.npc.NPC;
import com.equestricraft.core.npc.NPCRepository;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestFollowObjectiveWaypoint;
import com.equestricraft.core.quest.element.QuestObjective;
import com.equestricraft.core.quest.element.lifecycle.QuestFollowNpcObjectiveLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.util.List;
import java.util.UUID;

public class QuestFollowNpcObjective
extends QuestObjective {
    private final Integer npcId;
    private final int followMinimumDistance;
    private final int followMaximumDistance;
    private final String followTooCloseMessage;
    private final String followTooFarMessage;
    private List<QuestFollowObjectiveWaypoint> waypoints;
    @Service
    private static NPCRepository npcRepository;
    private final CachedValue<NPC> npc = CachedValue.build(() -> (NPC)npcRepository.findByKey(this.getNpcId())).expiredIfOlderThanDuration(npcRepository::getDurationSinceLastLoad).complete();

    public QuestFollowNpcObjective(UUID id, String name, String nameKey, Quest quest, String startMessage, String hint, boolean silent, boolean showTitle, boolean showOnCompass, Integer npcId, int followMinimumDistance, int followMaximumDistance, String followTooCloseMessage, String followTooFarMessage) {
        super(id, name, nameKey, quest, startMessage, hint, silent, showTitle, showOnCompass);
        this.npcId = npcId;
        this.followMinimumDistance = followMinimumDistance;
        this.followMaximumDistance = followMaximumDistance;
        this.followTooCloseMessage = followTooCloseMessage;
        this.followTooFarMessage = followTooFarMessage;
    }

    public Integer getNpcId() {
        return this.npcId;
    }

    public NPC getNpc() {
        return this.npc.get();
    }

    public int getFollowMinimumDistance() {
        return this.followMinimumDistance;
    }

    public int getFollowMaximumDistance() {
        return this.followMaximumDistance;
    }

    public String getFollowTooCloseMessage() {
        return this.followTooCloseMessage;
    }

    public String getFollowTooFarMessage() {
        return this.followTooFarMessage;
    }

    public List<QuestFollowObjectiveWaypoint> getWaypoints() {
        return this.waypoints;
    }

    public void setWaypoints(List<QuestFollowObjectiveWaypoint> waypoints) {
        this.waypoints = waypoints;
    }

    @Override
    public QuestElementType getQuestElementType() {
        return QuestElementType.FOLLOW_NPC;
    }

    @Override
    public QuestFollowNpcObjectiveLifecycle getLifecycle(QuestPlayer player) {
        return (QuestFollowNpcObjectiveLifecycle)player.getTrackedQuestState().requireElementLifecycle(this);
    }

    @Override
    public QuestFollowNpcObjectiveLifecycle getNewLifecycle(QuestPlayer player) {
        return new QuestFollowNpcObjectiveLifecycle(this, player);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

