/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element;

import com.equestricraft.base.worldarea.WorldArea;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.CachedValue;
import com.equestricraft.common.QuestElementType;
import com.equestricraft.common.QuestLocationChangeMode;
import com.equestricraft.core.npc.NPC;
import com.equestricraft.core.npc.NPCRepository;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.element.QuestObjective;
import com.equestricraft.core.quest.element.lifecycle.QuestLocationChangeObjectiveLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.util.UUID;

public class QuestLocationChangeObjective
extends QuestObjective {
    private final WorldArea locationChangeArea;
    private final QuestLocationChangeMode locationChangeMode;
    private final Integer followingNpcId;
    private final Double followingNpcSpeed;
    @Service
    private static NPCRepository npcRepository;
    private final CachedValue<NPC> followingNpc = CachedValue.build(() -> (NPC)npcRepository.findByKey(this.getFollowingNpcId())).expiredIfOlderThanDuration(npcRepository::getDurationSinceLastLoad).complete();

    public QuestLocationChangeObjective(UUID id, String name, String nameKey, Quest quest, String startMessage, String hint, boolean silent, boolean showTitle, boolean showOnCompass, WorldArea locationChangeArea, QuestLocationChangeMode locationChangeMode, Integer followingNpcId, Double followingNpcSpeed) {
        super(id, name, nameKey, quest, startMessage, hint, silent, showTitle, showOnCompass);
        this.locationChangeArea = locationChangeArea;
        this.locationChangeMode = locationChangeMode;
        this.followingNpcId = followingNpcId;
        this.followingNpcSpeed = followingNpcSpeed;
    }

    public WorldArea getLocationChangeArea() {
        return this.locationChangeArea;
    }

    public QuestLocationChangeMode getLocationChangeMode() {
        return this.locationChangeMode;
    }

    public Integer getFollowingNpcId() {
        return this.followingNpcId;
    }

    public NPC getFollowingNpc() {
        return this.followingNpc.get();
    }

    public Double getFollowingNpcSpeed() {
        return this.followingNpcSpeed;
    }

    @Override
    public QuestElementType getQuestElementType() {
        return QuestElementType.LOCATION_CHANGE;
    }

    @Override
    public QuestLocationChangeObjectiveLifecycle getLifecycle(QuestPlayer player) {
        return (QuestLocationChangeObjectiveLifecycle)player.getTrackedQuestState().requireElementLifecycle(this);
    }

    @Override
    public QuestLocationChangeObjectiveLifecycle getNewLifecycle(QuestPlayer player) {
        return new QuestLocationChangeObjectiveLifecycle(this, player);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

