/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element;

import com.equestricraft.common.QuestElementType;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.element.QuestObjective;
import com.equestricraft.core.quest.element.lifecycle.QuestScriptedObjectiveLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.util.UUID;

public class QuestScriptedObjective
extends QuestObjective {
    private final String scriptText;
    private final Integer secondsInterval;

    public QuestScriptedObjective(UUID id, String name, String nameKey, Quest quest, String startMessage, String hint, boolean silent, boolean showTitle, boolean showOnCompass, String scriptText, Integer secondsInterval) {
        super(id, name, nameKey, quest, startMessage, hint, silent, showTitle, showOnCompass);
        this.scriptText = scriptText;
        this.secondsInterval = secondsInterval;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public Integer getSecondsInterval() {
        return this.secondsInterval;
    }

    @Override
    public QuestElementType getQuestElementType() {
        return QuestElementType.SCRIPTED_OBJECTIVE;
    }

    @Override
    public QuestScriptedObjectiveLifecycle getLifecycle(QuestPlayer player) {
        return (QuestScriptedObjectiveLifecycle)player.getTrackedQuestState().requireElementLifecycle(this);
    }

    @Override
    public QuestScriptedObjectiveLifecycle getNewLifecycle(QuestPlayer player) {
        return new QuestScriptedObjectiveLifecycle(this, player);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

