/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element;

import com.equestricraft.base.worldarea.WorldArea;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.CachedValue;
import com.equestricraft.common.DaysOfWeek;
import com.equestricraft.common.QuestElementType;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.npc.NPC;
import com.equestricraft.core.npc.NPCRepository;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.RequiredCharacter;
import com.equestricraft.core.quest.RequiredQuest;
import com.equestricraft.core.quest.element.QuestElement;
import com.equestricraft.core.quest.element.lifecycle.QuestStartElementLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class QuestStartElement
extends QuestElement {
    private final Integer npcId;
    private final BlockCoordinate blockInteract;
    private final WorldArea locationReachArea;
    private final Date startTime;
    private final Date endTime;
    private final int xpRequired;
    private final boolean allowMultiplePlay;
    private final int playCoolDownHours;
    private final String preConditionScript;
    private final DaysOfWeek playableDays;
    private List<RequiredQuest> requiredQuests;
    private List<RequiredCharacter> requiredCharacters;
    @Service
    private static NPCRepository npcRepository;
    private final CachedValue<NPC> npc = CachedValue.build(() -> (NPC)npcRepository.findByKey(this.getNpcId())).expiredIfOlderThanDuration(npcRepository::getDurationSinceLastLoad).complete();

    public QuestStartElement(UUID id, String name, String nameKey, Quest quest, Integer npcId, BlockCoordinate blockInteract, WorldArea locationReachArea, Date startTime, Date endTime, int xpRequired, boolean allowMultiplePlay, int playCoolDownHours, String preConditionScript, DaysOfWeek playableDays) {
        super(id, name, nameKey, quest);
        this.npcId = npcId;
        this.blockInteract = blockInteract;
        this.locationReachArea = locationReachArea;
        this.startTime = startTime;
        this.endTime = endTime;
        this.xpRequired = xpRequired;
        this.allowMultiplePlay = allowMultiplePlay;
        this.playCoolDownHours = playCoolDownHours;
        this.preConditionScript = preConditionScript;
        this.playableDays = playableDays;
    }

    public Integer getNpcId() {
        return this.npcId;
    }

    public NPC getNpc() {
        return this.npc.get();
    }

    public BlockCoordinate getBlockInteract() {
        return this.blockInteract;
    }

    public WorldArea getLocationReachArea() {
        return this.locationReachArea;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public boolean isTimeActive() {
        return !(this.startTime != null && !DateUtils.isInPast(this.startTime) || this.endTime != null && !DateUtils.isInFuture(this.endTime));
    }

    public int getXpRequired() {
        return this.xpRequired;
    }

    public boolean isAllowMultiplePlay() {
        return this.allowMultiplePlay;
    }

    public int getPlayCoolDownHours() {
        return this.playCoolDownHours;
    }

    public String getPreConditionScript() {
        return this.preConditionScript;
    }

    public DaysOfWeek getPlayableDays() {
        return this.playableDays;
    }

    public List<RequiredQuest> getRequiredQuests() {
        return this.requiredQuests;
    }

    public void setRequiredQuests(List<RequiredQuest> requiredQuests) {
        this.requiredQuests = requiredQuests;
    }

    public List<RequiredCharacter> getRequiredCharacters() {
        return this.requiredCharacters;
    }

    public void setRequiredCharacters(List<RequiredCharacter> requiredCharacters) {
        this.requiredCharacters = requiredCharacters;
    }

    public boolean isBlankStarter() {
        return this.getNpc() == null && this.getLocationReachArea() == null && this.getBlockInteract() == null;
    }

    @Override
    public QuestElementType getQuestElementType() {
        return QuestElementType.STARTER;
    }

    public QuestStartElementLifecycle getLifecycle(QuestPlayer player) {
        return (QuestStartElementLifecycle)player.getTrackedQuestState().requireElementLifecycle(this);
    }

    public QuestStartElementLifecycle getNewLifecycle(QuestPlayer player) {
        return new QuestStartElementLifecycle(this, player);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

