/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.conversation;

import com.equestricraft.core.quest.element.conversation.QuestConversationActionProcessQueueEntry;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionResponse;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;

public class QuestConversationActionProcessQueue {
    private static final QuestConversationActionProcessQueue instance = new QuestConversationActionProcessQueue();
    private final BlockingQueue<QuestConversationActionProcessQueueEntry> conversationActions = new LinkedBlockingQueue<QuestConversationActionProcessQueueEntry>();
    private Thread thread = null;
    private boolean running = true;

    public static QuestConversationActionProcessQueue getInstance() {
        return instance;
    }

    private QuestConversationActionProcessQueue() {
    }

    public void queueAction(QuestPlayer player, QuestConversationActionResponse actionResponse) {
        if (!this.running) {
            throw new IllegalStateException("Queue is not running");
        }
        QuestConversationActionProcessQueueEntry entry = new QuestConversationActionProcessQueueEntry(player, actionResponse);
        this.conversationActions.add(entry);
    }

    public void consumeActions(Consumer<QuestConversationActionProcessQueueEntry> consumer) {
        if (this.thread != null) {
            throw new IllegalStateException("Already started");
        }
        this.thread = new Thread(() -> {
            while (this.running) {
                try {
                    QuestConversationActionProcessQueueEntry nextAction = this.conversationActions.take();
                    consumer.accept(nextAction);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }, "Quest conversation action processor");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void shutdown() {
        this.running = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }
}

