/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.conversation;

import com.equestricraft.common.QuestElementOutputType;
import com.equestricraft.core.quest.QuestComponent;
import com.equestricraft.core.quest.element.QuestConversationObjective;
import com.equestricraft.core.quest.element.conversation.QuestConversationElementOutput;
import com.equestricraft.core.quest.element.conversation.lifecycle.QuestConversationElementLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public abstract class QuestConversationElement
implements QuestComponent<QuestConversationObjective> {
    private final UUID id;
    private final QuestConversationObjective objective;
    private final boolean startingElement;
    private List<QuestConversationElementOutput> outputs;

    QuestConversationElement(UUID id, QuestConversationObjective objective, boolean startingElement) {
        this.id = id;
        this.objective = objective;
        this.startingElement = startingElement;
    }

    public UUID getId() {
        return this.id;
    }

    public QuestConversationObjective getObjective() {
        return this.objective;
    }

    public boolean isStartingElement() {
        return this.startingElement;
    }

    public List<QuestConversationElementOutput> getOutputs() {
        return this.outputs;
    }

    public QuestConversationElementOutput getOutputById(UUID id) {
        return this.getOutputs().stream().filter(o -> o.getId().equals(id)).findFirst().orElseThrow();
    }

    public QuestConversationElementOutput getOutputByIdentifier(String outputIdentifier) {
        return this.getOutputs().stream().filter(o -> o.getIdentifier().equals(outputIdentifier)).findFirst().orElseThrow();
    }

    public QuestConversationElementOutput getOutputByType(QuestElementOutputType type) {
        return this.getOutputs().stream().filter(o -> o.getType().equals((Object)type)).findFirst().orElseThrow();
    }

    public QuestConversationElementOutput getSuccessOutput() {
        return this.getOutputByType(QuestElementOutputType.SUCCESS);
    }

    public QuestConversationElementOutput getFailureOutput() {
        return this.getOutputByType(QuestElementOutputType.FAILURE);
    }

    public void setOutputs(List<QuestConversationElementOutput> outputs) {
        this.outputs = outputs;
    }

    @Override
    public QuestConversationObjective getElement() {
        return this.getObjective();
    }

    public abstract QuestConversationElementLifecycle<?> getLifecycle(QuestPlayer var1);

    public abstract QuestConversationElementLifecycle<?> getNewLifecycle(QuestPlayer var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuestConversationElement that = (QuestConversationElement)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.objective.toString() + " > " + this.id.toString();
    }
}

