/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.conversation;

import com.equestricraft.common.QuestConversationPromptType;
import com.equestricraft.core.quest.element.QuestConversationObjective;
import com.equestricraft.core.quest.element.conversation.QuestConversationElement;
import com.equestricraft.core.quest.element.conversation.lifecycle.QuestConversationPromptElementLifecycle;
import com.equestricraft.core.quest.prompt.QuestConversationPromptChoice;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.util.List;
import java.util.UUID;

public class QuestConversationPromptElement
extends QuestConversationElement {
    private final String title;
    private final String text;
    private final QuestConversationPromptType type;
    private final String promptScript;
    private final String validationScript;
    private final String processingScript;
    private List<QuestConversationPromptChoice> choices;

    public QuestConversationPromptElement(UUID id, QuestConversationObjective conversationObjective, boolean startingElement, String title, String text, QuestConversationPromptType type, String promptScript, String validationScript, String processingScript) {
        super(id, conversationObjective, startingElement);
        this.title = title;
        this.text = text;
        this.type = type;
        this.promptScript = promptScript;
        this.validationScript = validationScript;
        this.processingScript = processingScript;
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public QuestConversationPromptType getType() {
        return this.type;
    }

    public String getPromptScript() {
        return this.promptScript;
    }

    public String getValidationScript() {
        return this.validationScript;
    }

    public String getProcessingScript() {
        return this.processingScript;
    }

    public List<QuestConversationPromptChoice> getChoices() {
        return this.choices;
    }

    public QuestConversationPromptChoice getChoiceById(int id) {
        return this.getChoices().stream().filter(c -> c.getId() == id).findFirst().orElseThrow();
    }

    public void setChoices(List<QuestConversationPromptChoice> choices) {
        this.choices = choices;
    }

    public QuestConversationPromptElementLifecycle getLifecycle(QuestPlayer player) {
        return (QuestConversationPromptElementLifecycle)player.getTrackedQuestState().requireConversationElementLifecycle(this);
    }

    public QuestConversationPromptElementLifecycle getNewLifecycle(QuestPlayer player) {
        return new QuestConversationPromptElementLifecycle(this, player);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return this.title;
    }
}

