/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.conversation.lifecycle;

import com.equestricraft.core.quest.element.conversation.QuestConversationActionResponse;
import com.equestricraft.core.quest.element.conversation.QuestConversationElement;
import com.equestricraft.core.quest.element.conversation.QuestConversationElementOutput;
import com.equestricraft.core.quest.element.conversation.lifecycle.NextElementResponse;
import com.equestricraft.core.quest.element.lifecycle.QuestConversationObjectiveLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Optional;

public abstract class QuestConversationElementLifecycle<E extends QuestConversationElement> {
    final E conversationElement;
    final QuestPlayer player;

    QuestConversationElementLifecycle(E conversationElement, QuestPlayer player) {
        this.conversationElement = conversationElement;
        this.player = player;
    }

    public final void resume() {
        this.onResume();
    }

    void onResume() {
    }

    public final QuestConversationActionResponse process() {
        this.getObjectiveLifecycle().setCurrentConversationElement((QuestConversationElement)this.conversationElement);
        return this.onProcess();
    }

    abstract QuestConversationActionResponse onProcess();

    public Optional<QuestConversationActionResponse> postProcess(Object promptInput) {
        return Optional.empty();
    }

    public void reset() {
    }

    public NextElementResponse getNextElement(Object promptInput) {
        QuestConversationElementOutput successOutput = ((QuestConversationElement)this.conversationElement).getSuccessOutput();
        return this.buildResponseFromOutput(successOutput);
    }

    NextElementResponse buildResponseFromOutput(QuestConversationElementOutput output) {
        return new NextElementResponse(output.getNextConversationElement(), output.getElementOutput(), true);
    }

    public final E getConversationElement() {
        return this.conversationElement;
    }

    final QuestConversationObjectiveLifecycle getObjectiveLifecycle() {
        return (QuestConversationObjectiveLifecycle)this.player.getTrackedQuestState().requireElementLifecycle(((QuestConversationElement)this.conversationElement).getElement());
    }

    public void serialize(DataOutputStream outputStream2) throws IOException {
    }

    public void deserialize(DataInputStream inputStream2) throws IOException {
    }
}

