/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.conversation.lifecycle;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.QuestConversationPromptType;
import com.equestricraft.core.quest.QuestException;
import com.equestricraft.core.quest.QuestScriptSession;
import com.equestricraft.core.quest.QuestStringInterpolator;
import com.equestricraft.core.quest.QuestTransformer;
import com.equestricraft.core.quest.ValidationScriptResponse;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionInvalidInputResponse;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionPromptResponse;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionResponse;
import com.equestricraft.core.quest.element.conversation.QuestConversationElementOutput;
import com.equestricraft.core.quest.element.conversation.QuestConversationPromptElement;
import com.equestricraft.core.quest.element.conversation.lifecycle.NextElementResponse;
import com.equestricraft.core.quest.element.conversation.lifecycle.QuestConversationElementLifecycle;
import com.equestricraft.core.quest.placeholder.QuestPlaceholderSession;
import com.equestricraft.core.quest.prompt.QuestAlertPrompt;
import com.equestricraft.core.quest.prompt.QuestChoicePrompt;
import com.equestricraft.core.quest.prompt.QuestConversationPromptChoice;
import com.equestricraft.core.quest.prompt.QuestPrompt;
import com.equestricraft.core.quest.prompt.QuestScriptPrompt;
import com.equestricraft.core.quest.prompt.QuestTextPrompt;
import com.equestricraft.core.quest.prompt.QuestYesNoPrompt;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyScriptResponse;
import com.equestricraft.groovy.executor.GroovyStandardScriptExecutor;
import com.equestricraft.logging.Log;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class QuestConversationPromptElementLifecycle
extends QuestConversationElementLifecycle<QuestConversationPromptElement> {
    @Service
    private static QuestPlaceholderSession questPlaceholderSession;
    @Service
    private static QuestTransformer questTransformer;
    @Service
    private static QuestScriptSession questScriptSession;
    private static final Log log;

    public QuestConversationPromptElementLifecycle(QuestConversationPromptElement conversationElement, QuestPlayer player) {
        super(conversationElement, player);
    }

    @Override
    QuestConversationActionResponse onProcess() {
        QuestPrompt promptObjects = this.buildPromptObject();
        return new QuestConversationActionPromptResponse(((QuestConversationPromptElement)this.conversationElement).getObjective(), promptObjects);
    }

    private QuestPrompt buildPromptObject() {
        String title = this.titleOrDefault(((QuestConversationPromptElement)this.conversationElement).getTitle(), ((QuestConversationPromptElement)this.conversationElement).getType());
        title = questPlaceholderSession.translatePlaceholders(title, this.player, ((QuestConversationPromptElement)this.conversationElement).getQuest());
        title = new QuestStringInterpolator(this.player, this.getObjectiveLifecycle()).execute(title);
        String text = questPlaceholderSession.translatePlaceholders(((QuestConversationPromptElement)this.conversationElement).getText(), this.player, ((QuestConversationPromptElement)this.conversationElement).getQuest());
        text = new QuestStringInterpolator(this.player, this.getObjectiveLifecycle()).execute(text);
        return switch (((QuestConversationPromptElement)this.conversationElement).getType()) {
            default -> throw new IncompatibleClassChangeError();
            case QuestConversationPromptType.ALERT -> new QuestAlertPrompt(((QuestConversationPromptElement)this.conversationElement).getId(), title, text);
            case QuestConversationPromptType.CHOICE -> new QuestChoicePrompt(((QuestConversationPromptElement)this.conversationElement).getId(), title, text, this.buildChoices(((QuestConversationPromptElement)this.conversationElement).getChoices()));
            case QuestConversationPromptType.TEXT -> new QuestTextPrompt(((QuestConversationPromptElement)this.conversationElement).getId(), title, text);
            case QuestConversationPromptType.YES_NO -> new QuestYesNoPrompt(((QuestConversationPromptElement)this.conversationElement).getId(), title, text);
            case QuestConversationPromptType.SCRIPT -> new QuestScriptPrompt(((QuestConversationPromptElement)this.conversationElement).getId(), title, text, ((QuestConversationPromptElement)this.conversationElement).getPromptScript());
        };
    }

    private String titleOrDefault(String title, QuestConversationPromptType type) {
        return Optional.ofNullable(title).filter(Predicate.not(String::isBlank)).orElseGet(type::getTranslatedDefaultDialogTitle);
    }

    private List<QuestChoicePrompt.Choice> buildChoices(List<QuestConversationPromptChoice> choices) {
        return choices.stream().sorted(Comparator.comparingInt(QuestConversationPromptChoice::getDisplayOrder)).map(c -> new QuestChoicePrompt.Choice(c.getId(), c.getLabel())).toList();
    }

    @Override
    public Optional<QuestConversationActionResponse> postProcess(Object promptInput) {
        if (promptInput == null) {
            return Optional.empty();
        }
        ValidationScriptResponse validationResponse = this.validateInput(promptInput);
        if (validationResponse.invalid()) {
            return Optional.of(new QuestConversationActionInvalidInputResponse((QuestConversationPromptElement)this.conversationElement, validationResponse.message()));
        }
        this.executeProcessingScript(promptInput);
        return Optional.empty();
    }

    private <T> ValidationScriptResponse validateInput(T promptInput) {
        if (((QuestConversationPromptElement)this.conversationElement).getValidationScript() == null) {
            return new ValidationScriptResponse(true, null);
        }
        try {
            GroovyStandardScriptExecutor executor = GroovyStandardScriptExecutor.start(((QuestConversationPromptElement)this.conversationElement).getValidationScript());
            questScriptSession.initCoreVariables(executor, this.player);
            executor.withVariable("input", promptInput);
            executor.withVariable("validationResult", true);
            executor.withBlankVariable("failMessage");
            GroovyScriptResponse response = executor.execute();
            questScriptSession.syncNewlyDefinedVariables(response, this.player);
            Boolean result = response.getBooleanVariable("validationResult");
            String message = response.getStringVariable("failMessage");
            return new ValidationScriptResponse(result, message);
        }
        catch (GroovyException ex) {
            log.error("Error running validation script for prompt input", ex);
            throw new QuestException(ex);
        }
    }

    private <T> void executeProcessingScript(T promptInput) {
        if (((QuestConversationPromptElement)this.conversationElement).getProcessingScript() == null) {
            return;
        }
        try {
            GroovyStandardScriptExecutor executor = GroovyStandardScriptExecutor.start(((QuestConversationPromptElement)this.conversationElement).getProcessingScript());
            questScriptSession.initCoreVariables(executor, this.player);
            executor.withVariable("input", promptInput);
            GroovyScriptResponse response = executor.execute();
            questScriptSession.syncNewlyDefinedVariables(response, this.player);
        }
        catch (GroovyException ex) {
            log.error("Error running processing script for prompt input", ex);
            throw new QuestException(ex);
        }
    }

    @Override
    public NextElementResponse getNextElement(Object promptInput) {
        if (promptInput == null) {
            return new NextElementResponse(this.conversationElement, null, false);
        }
        QuestConversationElementOutput conversationElementOutput = this.getIdOfNextElementFromPromptResponse(promptInput);
        return this.buildResponseFromOutput(conversationElementOutput);
    }

    private QuestConversationElementOutput getIdOfNextElementFromPromptResponse(Object result) {
        return switch (((QuestConversationPromptElement)this.conversationElement).getType()) {
            default -> throw new IncompatibleClassChangeError();
            case QuestConversationPromptType.ALERT, QuestConversationPromptType.TEXT, QuestConversationPromptType.SCRIPT -> ((QuestConversationPromptElement)this.conversationElement).getSuccessOutput();
            case QuestConversationPromptType.YES_NO -> this.getOutputFromYesOrNo(result);
            case QuestConversationPromptType.CHOICE -> this.getOutputFromChoice(result);
        };
    }

    private QuestConversationElementOutput getOutputFromYesOrNo(Object result) {
        boolean wasYes = (Boolean)result;
        return wasYes ? ((QuestConversationPromptElement)this.conversationElement).getSuccessOutput() : ((QuestConversationPromptElement)this.conversationElement).getFailureOutput();
    }

    private QuestConversationElementOutput getOutputFromChoice(Object result) {
        int id = (Integer)result;
        QuestConversationPromptChoice selectedChoice = ((QuestConversationPromptElement)this.conversationElement).getChoiceById(id);
        return ((QuestConversationPromptElement)this.conversationElement).getOutputById(selectedChoice.getConversationElementOutputId());
    }

    static {
        log = Log.getLogger(QuestConversationPromptElementLifecycle.class.getName());
    }
}

