/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.conversation.lifecycle;

import com.equestricraft.base.eventbus.ECEventBus;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.npc.NPCTpPlayerNpcEvent;
import com.equestricraft.core.quest.OutputIdentifierFunction;
import com.equestricraft.core.quest.QuestException;
import com.equestricraft.core.quest.QuestObjectiveNpcTeleportFunction;
import com.equestricraft.core.quest.QuestScriptSession;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionObjectiveCompleteResponse;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionResponse;
import com.equestricraft.core.quest.element.conversation.QuestConversationElementOutput;
import com.equestricraft.core.quest.element.conversation.QuestConversationScriptElement;
import com.equestricraft.core.quest.element.conversation.lifecycle.QuestConversationElementLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyScriptResponse;
import com.equestricraft.groovy.executor.GroovyStandardScriptExecutor;
import com.equestricraft.logging.Log;

public class QuestConversationScriptElementLifecycle
extends QuestConversationElementLifecycle<QuestConversationScriptElement> {
    @Service
    private static QuestScriptSession questScriptSession;
    private static final Log log;

    public QuestConversationScriptElementLifecycle(QuestConversationScriptElement conversationElement, QuestPlayer player) {
        super(conversationElement, player);
    }

    @Override
    QuestConversationActionResponse onProcess() {
        OutputActivationResponse outputToTrigger = this.executeScriptElement();
        if (outputToTrigger.noneSpecified()) {
            return this.getObjectiveLifecycle().advance();
        }
        QuestConversationElementOutput output = this.getOutput(outputToTrigger);
        if (output.getElementOutput() != null) {
            return new QuestConversationActionObjectiveCompleteResponse(((QuestConversationScriptElement)this.conversationElement).getObjective(), output.getElementOutput());
        }
        if (output.getNextConversationElement() != null) {
            return output.getNextConversationElement().getLifecycle(this.player).process();
        }
        throw new IllegalArgumentException(String.format("Invalid output: %s", output.getIdentifier()));
    }

    private OutputActivationResponse executeScriptElement() {
        GroovyStandardScriptExecutor executor = GroovyStandardScriptExecutor.start(((QuestConversationScriptElement)this.conversationElement).getScriptText());
        questScriptSession.initCoreVariables(executor, this.player);
        executor.withBlankVariable("outputIdentifier");
        OutputIdentifierFunction outputIdentifierFunction = new OutputIdentifierFunction();
        executor.withVariable("output", outputIdentifierFunction);
        QuestObjectiveNpcTeleportFunction objectiveNpcTeleportFunction = new QuestObjectiveNpcTeleportFunction();
        executor.withVariable("teleportNpc", objectiveNpcTeleportFunction);
        try {
            String output;
            GroovyScriptResponse response = executor.execute();
            questScriptSession.syncNewlyDefinedVariables(response, this.player);
            DirectionalCoordinate npcTeleportLocation = objectiveNpcTeleportFunction.getDirectionalCoordinate();
            if (npcTeleportLocation != null) {
                Coordinate coordinate = new Coordinate(npcTeleportLocation.x(), npcTeleportLocation.y(), npcTeleportLocation.z(), npcTeleportLocation.world());
                NPCTpPlayerNpcEvent event = new NPCTpPlayerNpcEvent(((QuestConversationScriptElement)this.conversationElement).getElement().getNpc(), this.player, coordinate);
                ECEventBus.post(event);
            }
            if ((output = response.getStringVariable("outputIdentifier")) != null) {
                return new OutputActivationResponse(false, false, output);
            }
            if (outputIdentifierFunction.isSuccess()) {
                return new OutputActivationResponse(true, false, null);
            }
            if (outputIdentifierFunction.isFailure()) {
                return new OutputActivationResponse(false, true, null);
            }
            String identifier = outputIdentifierFunction.pickRandomSingle().orElse(null);
            return new OutputActivationResponse(false, false, identifier);
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing script for conversation element %s", ((QuestConversationScriptElement)this.conversationElement).getId().toString()));
            throw new QuestException(ex);
        }
    }

    private QuestConversationElementOutput getOutput(OutputActivationResponse outputToTrigger) {
        if (outputToTrigger.success()) {
            return ((QuestConversationScriptElement)this.conversationElement).getSuccessOutput();
        }
        if (outputToTrigger.failure()) {
            return ((QuestConversationScriptElement)this.conversationElement).getFailureOutput();
        }
        return ((QuestConversationScriptElement)this.conversationElement).getOutputByIdentifier(outputToTrigger.identifier());
    }

    static {
        log = Log.getLogger(QuestConversationScriptElementLifecycle.class.getName());
    }

    private record OutputActivationResponse(boolean success, boolean failure, String identifier) {
        boolean noneSpecified() {
            return !this.success && !this.failure && this.identifier == null;
        }
    }
}

