/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.conversation.lifecycle;

import com.equestricraft.base.eventbus.ECEventBus;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.base.text.TextItem;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.QuestConversationLineSpeaker;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.character.CharacterProfile;
import com.equestricraft.core.npc.NPCTpPlayerNpcEvent;
import com.equestricraft.core.npc.NPCWaypointSetEvent;
import com.equestricraft.core.quest.QuestConversationActionResponseEvent;
import com.equestricraft.core.quest.QuestSettings;
import com.equestricraft.core.quest.QuestStringInterpolator;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionAutoAdvanceResponse;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionDefaultResponse;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionResponse;
import com.equestricraft.core.quest.element.conversation.QuestConversationTextElement;
import com.equestricraft.core.quest.element.conversation.QuestConversationTextElementLine;
import com.equestricraft.core.quest.element.conversation.QuestConversationTextElementLineWaypoint;
import com.equestricraft.core.quest.element.conversation.lifecycle.NextElementResponse;
import com.equestricraft.core.quest.element.conversation.lifecycle.QuestConversationElementLifecycle;
import com.equestricraft.core.quest.placeholder.QuestPlaceholderSession;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class QuestConversationTextElementLifecycle
extends QuestConversationElementLifecycle<QuestConversationTextElement> {
    @Service
    private static QuestPlaceholderSession questPlaceholderSession;
    private Integer currentConversationLineIndex = null;
    private Coordinate currentNpcLocation = null;
    private QuestConversationTextElementLineWaypoint targetWaypoint = null;
    private static final TextItem prefixStart;
    private static final TextItem prefixEnd;

    public QuestConversationTextElementLifecycle(QuestConversationTextElement conversationElement, QuestPlayer player) {
        super(conversationElement, player);
    }

    @Override
    void onResume() {
        if (this.currentNpcLocation != null) {
            this.teleportNpc(this.currentNpcLocation);
        }
        if (this.currentConversationLineIndex != null) {
            QuestConversationTextElementLine lineToPlay = ((QuestConversationTextElement)this.conversationElement).getLines().get(this.currentConversationLineIndex);
            QuestConversationActionResponse response = this.playLine(lineToPlay);
            if (this.targetWaypoint != null) {
                CompletableFuture<Object> future = new CompletableFuture<Object>();
                this.setWaypoint(lineToPlay, future, this.targetWaypoint);
                response = new QuestConversationActionAutoAdvanceResponse(((QuestConversationTextElement)this.conversationElement).getObjective(), future);
            }
            QuestConversationActionResponseEvent event = new QuestConversationActionResponseEvent(this.player, response);
            ECEventBus.post(event);
        }
    }

    private void teleportNpc(Coordinate location) {
        NPCTpPlayerNpcEvent event = new NPCTpPlayerNpcEvent(((QuestConversationTextElement)this.getConversationElement()).getObjective().getNpc(), this.player, location);
        ECEventBus.post(event);
    }

    @Override
    QuestConversationActionResponse onProcess() {
        int nextLineIndex = this.currentConversationLineIndex != null ? this.currentConversationLineIndex + 1 : 0;
        QuestConversationTextElementLine lineToPlay = ((QuestConversationTextElement)this.conversationElement).getLines().get(nextLineIndex);
        this.targetWaypoint = null;
        QuestConversationActionResponse response = this.playLine(lineToPlay);
        this.currentConversationLineIndex = nextLineIndex;
        return response;
    }

    private QuestConversationActionResponse playLine(QuestConversationTextElementLine line) {
        this.showConversationLine(line);
        this.logPlayersInteractionWithCharacter(line);
        if (line.shouldAutoPlayNext()) {
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            Duration duration = Duration.ofSeconds(line.getAutoPlayNextSeconds().intValue());
            TaskScheduler.executeAsyncTask(() -> {
                this.getObjectiveLifecycle().setPreventManualAdvance(false);
                future.complete(null);
            }, duration);
            this.getObjectiveLifecycle().setPreventManualAdvance(true);
            return new QuestConversationActionAutoAdvanceResponse(line.getTextElement().getObjective(), future);
        }
        if (!line.getWaypoints().isEmpty() && this.targetWaypoint == null) {
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            this.setWaypoint(line, future, line.getWaypoints().get(0));
            this.getObjectiveLifecycle().setPreventManualAdvance(true);
            return new QuestConversationActionAutoAdvanceResponse(line.getTextElement().getObjective(), future);
        }
        return new QuestConversationActionDefaultResponse(line.getTextElement().getObjective());
    }

    private void showConversationLine(QuestConversationTextElementLine line) {
        String text = questPlaceholderSession.translatePlaceholders(line.getText(), this.player, line.getQuest());
        text = new QuestStringInterpolator(this.player, this.getObjectiveLifecycle()).execute(text);
        TextItem textToShow = this.attachSpeakerPrefix(text, line);
        this.player.sendMessage(textToShow);
    }

    private TextItem attachSpeakerPrefix(String text, QuestConversationTextElementLine line) {
        TextItem rootItem = new TextItem();
        Optional<TextItem> prefix = this.buildPrefix(line);
        if (prefix.isPresent()) {
            rootItem.addChildItem(prefix.get());
            rootItem.addChildItem(new TextItem(" "));
            rootItem.addChildItem(new TextItem(text));
            return rootItem;
        }
        rootItem.setText(text);
        return rootItem;
    }

    private Optional<TextItem> buildPrefix(QuestConversationTextElementLine line) {
        if (line.getSpeaker() == QuestConversationLineSpeaker.PLAYER) {
            TextItem rootItem = new TextItem();
            rootItem.addChildItem(prefixStart);
            rootItem.addChildItem(this.player.getDisplayName());
            rootItem.addChildItem(prefixEnd);
            return Optional.of(rootItem);
        }
        if (line.getSpeaker() == QuestConversationLineSpeaker.CHARACTER) {
            return Optional.of(this.buildCharacterPrefixForComponent(line));
        }
        return Optional.empty();
    }

    private TextItem buildCharacterPrefixForComponent(QuestConversationTextElementLine line) {
        return this.getCharacterForLine(line).map(this::buildPrefixForCharacter).orElse(new TextItem(""));
    }

    private void logPlayersInteractionWithCharacter(QuestConversationTextElementLine line) {
        Optional<CharacterProfile> questCharacterProfile = this.getCharacterForLine(line);
        questCharacterProfile.map(CharacterProfile::getId).ifPresent(this.player.getCharacters()::processInteraction);
    }

    private void setWaypoint(QuestConversationTextElementLine line, CompletableFuture<Object> future, QuestConversationTextElementLineWaypoint waypoint) {
        int maximumDistance = QuestSettings.getNpcMaximumDistanceFromPlayer();
        NPCWaypointSetEvent event = NPCWaypointSetEvent.Builder.start(line.getTextElement().getObjective().getNpc(), waypoint.getLocation()).withPlayer(this.player).withSpeed(waypoint.getSpeed() / 15.0).withMaximumDistance(maximumDistance, () -> this.alertIfNpcDistance(line), null, null).withOnReachAction(() -> TaskScheduler.executeAsyncTask(() -> this.processWaypointReached(line, future, waypoint))).complete();
        TaskScheduler.executeSyncTask(() -> ECEventBus.post(event));
        this.targetWaypoint = waypoint;
    }

    private void alertIfNpcDistance(QuestConversationTextElementLine line) {
        Optional<CharacterProfile> character = this.getCharacterForLine(line);
        TextItem prefix = character.map(this::buildPrefixForCharacter).orElse(new TextItem(""));
        String text = character.map(c -> this.getWaitText(line, (CharacterProfile)c)).orElse(I18n.getLabel("quest.npc-wait.message"));
        TextItem message = new TextItem();
        message.addChildItem(prefix);
        message.addChildItem(new TextItem(" "));
        message.addChildItem(new TextItem(text));
        this.player.sendMessage(message);
    }

    private String getWaitText(QuestConversationTextElementLine line, CharacterProfile character) {
        if (!line.getNpcWaitMessage().isBlank()) {
            return line.getNpcWaitMessage();
        }
        if (!line.getTextElement().getNpcWaitMessage().isBlank()) {
            return line.getTextElement().getNpcWaitMessage();
        }
        if (!character.getWaitMessage().isBlank()) {
            return character.getWaitMessage();
        }
        return I18n.getLabel("quest.npc-wait.message");
    }

    private void processWaypointReached(QuestConversationTextElementLine line, CompletableFuture<Object> future, QuestConversationTextElementLineWaypoint waypoint) {
        this.currentNpcLocation = waypoint.getLocation();
        Optional<QuestConversationTextElementLineWaypoint> nextWaypoint = line.getWaypoints().stream().filter(w -> w.getOrder() > waypoint.getOrder()).findFirst();
        if (nextWaypoint.isPresent()) {
            this.setWaypoint(line, future, nextWaypoint.get());
        } else {
            this.getObjectiveLifecycle().setPreventManualAdvance(false);
            future.complete(null);
        }
    }

    private TextItem buildPrefixForCharacter(CharacterProfile character) {
        TextItem rootItem = new TextItem();
        rootItem.addChildItem(prefixStart);
        TextItem prefix = new TextItem(character.getLinePrefix());
        prefix.setColor(character.getColor());
        rootItem.addChildItem(prefix);
        rootItem.addChildItem(prefixEnd);
        return rootItem;
    }

    private Optional<CharacterProfile> getCharacterForLine(QuestConversationTextElementLine line) {
        CharacterProfile characterProfile = line.getTextElement().getObjective().getNpc().getCharacterProfile();
        return Optional.ofNullable(characterProfile);
    }

    @Override
    public void reset() {
        this.currentConversationLineIndex = null;
        this.currentNpcLocation = null;
        this.targetWaypoint = null;
    }

    @Override
    public NextElementResponse getNextElement(Object promptInput) {
        if (this.currentConversationLineIndex == null) {
            return super.getNextElement(promptInput);
        }
        if (((QuestConversationTextElement)this.conversationElement).getLines().size() - 1 > this.currentConversationLineIndex) {
            return new NextElementResponse(this.conversationElement, null, false);
        }
        return super.getNextElement(promptInput);
    }

    @Override
    public void serialize(DataOutputStream outputStream2) throws IOException {
        if (this.currentConversationLineIndex != null) {
            outputStream2.writeBoolean(true);
            outputStream2.writeInt(this.currentConversationLineIndex);
        } else {
            outputStream2.writeBoolean(false);
        }
        if (this.currentNpcLocation != null) {
            outputStream2.writeBoolean(true);
            QuestConversationTextElementLifecycle.serializeCoordinate(outputStream2, this.currentNpcLocation);
        } else {
            outputStream2.writeBoolean(false);
        }
        if (this.targetWaypoint != null) {
            outputStream2.writeBoolean(true);
            outputStream2.writeUTF(this.targetWaypoint.getId().toString());
        } else {
            outputStream2.writeBoolean(false);
        }
    }

    @Override
    public void deserialize(DataInputStream inputStream2) throws IOException {
        UUID targetWaypointId;
        this.currentConversationLineIndex = inputStream2.readBoolean() ? Integer.valueOf(inputStream2.readInt()) : null;
        this.currentNpcLocation = inputStream2.readBoolean() ? QuestConversationTextElementLifecycle.deserializeCoordinate(inputStream2) : null;
        UUID uUID = targetWaypointId = inputStream2.readBoolean() ? UUID.fromString(inputStream2.readUTF()) : null;
        if (targetWaypointId != null && this.currentConversationLineIndex != null) {
            QuestConversationTextElementLine line = ((QuestConversationTextElement)this.conversationElement).getLines().get(this.currentConversationLineIndex);
            this.targetWaypoint = line.getWaypoints().stream().filter(w -> w.getId().equals(targetWaypointId)).findFirst().orElseThrow();
        }
    }

    private static void serializeCoordinate(DataOutputStream outputStream2, Coordinate coordinate) throws IOException {
        outputStream2.writeDouble(coordinate.x());
        outputStream2.writeDouble(coordinate.y());
        outputStream2.writeDouble(coordinate.z());
        outputStream2.writeUTF(coordinate.world());
    }

    private static Coordinate deserializeCoordinate(DataInputStream inputStream2) throws IOException {
        double x = inputStream2.readDouble();
        double y = inputStream2.readDouble();
        double z = inputStream2.readDouble();
        String world = inputStream2.readUTF();
        return new Coordinate(x, y, z, world);
    }

    static {
        prefixStart = new TextItem("&f&l[&r");
        prefixEnd = new TextItem("&f&l]&r");
    }
}

