/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.lifecycle;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.core.quest.QuestException;
import com.equestricraft.core.quest.QuestObjectiveBlockInteract;
import com.equestricraft.core.quest.QuestScriptSession;
import com.equestricraft.core.quest.element.QuestBlockInteractObjective;
import com.equestricraft.core.quest.element.lifecycle.QuestObjectiveElementLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import com.equestricraft.core.world.WorldService;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyScriptResponse;
import com.equestricraft.groovy.executor.GroovyStandardScriptExecutor;
import com.equestricraft.logging.Log;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;

public class QuestBlockInteractObjectiveLifecycle
extends QuestObjectiveElementLifecycle<QuestBlockInteractObjective> {
    @Service
    private static QuestScriptSession questScriptSession;
    @Service
    private static WorldService worldService;
    private final Set<UUID> interactedBlockIds = new LinkedHashSet<UUID>(0);
    private static final Log log;

    public QuestBlockInteractObjectiveLifecycle(QuestBlockInteractObjective element, QuestPlayer player) {
        super(element, player);
    }

    @Override
    void onObjectiveActivate() {
        ((QuestBlockInteractObjective)this.element).getBlockInteracts().stream().filter(b -> b.getBlockType() != null).forEach(b -> worldService.setTempBlockForPlayer(this.player, b.getBlockCoordinate(), b.getBlockType()));
        this.updateCompass();
    }

    @Override
    void onResume() {
        this.updateCompass();
    }

    private void updateCompass() {
        if (((QuestBlockInteractObjective)this.element).isShowOnCompass()) {
            for (QuestObjectiveBlockInteract blockInteract : ((QuestBlockInteractObjective)this.element).getBlockInteracts()) {
                Coordinate coordinate = new Coordinate(blockInteract.getBlockCoordinate().x(), blockInteract.getBlockCoordinate().y(), blockInteract.getBlockCoordinate().z(), blockInteract.getBlockCoordinate().world());
                this.player.getCompassManager().addCoordinates(blockInteract.getId(), coordinate);
            }
        }
    }

    public void advance(BlockCoordinate blockCoordinate) {
        QuestObjectiveBlockInteract blockInteract = ((QuestBlockInteractObjective)this.element).getBlockInteractForBlockCoordinate(blockCoordinate);
        if (this.interactedBlockIds.contains(blockInteract.getId())) {
            return;
        }
        this.interactedBlockIds.add(blockInteract.getId());
        this.executeOnCompleteScript(blockInteract);
        this.player.getCompassManager().removeCoordinates(blockInteract.getId());
        if (this.isRequiredInteractsDone()) {
            this.activateSuccessOutput();
        }
    }

    private void executeOnCompleteScript(QuestObjectiveBlockInteract blockInteract) {
        if (blockInteract.getOnCompleteScript() == null) {
            return;
        }
        GroovyStandardScriptExecutor executor = GroovyStandardScriptExecutor.start(blockInteract.getOnCompleteScript());
        questScriptSession.initCoreVariables(executor, this.player);
        try {
            GroovyScriptResponse response = executor.execute();
            questScriptSession.syncNewlyDefinedVariables(response, this.player);
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing on complete script for block interact %s", blockInteract.getId()), ex);
            throw new QuestException(ex);
        }
    }

    private boolean isRequiredInteractsDone() {
        boolean anyRequiredNotInteracted = ((QuestBlockInteractObjective)this.element).getBlockInteracts().stream().filter(Predicate.not(QuestObjectiveBlockInteract::isOptional)).map(QuestObjectiveBlockInteract::getId).anyMatch(Predicate.not(this.interactedBlockIds::contains));
        if (anyRequiredNotInteracted) {
            return false;
        }
        int optionalsFound = (int)((QuestBlockInteractObjective)this.element).getBlockInteracts().stream().filter(QuestObjectiveBlockInteract::isOptional).map(QuestObjectiveBlockInteract::getId).filter(this.interactedBlockIds::contains).count();
        return optionalsFound >= ((QuestBlockInteractObjective)this.element).getRequiredOptionalBlockInteracts();
    }

    @Override
    void onDeactivate() {
        ((QuestBlockInteractObjective)this.element).getBlockInteracts().stream().map(QuestObjectiveBlockInteract::getId).forEach(id -> this.player.getCompassManager().removeCoordinates((UUID)id));
    }

    @Override
    void reset() {
        this.interactedBlockIds.clear();
    }

    @Override
    public void onSerialize(DataOutputStream outputStream2) throws IOException {
        outputStream2.writeInt(this.interactedBlockIds.size());
        for (UUID id : this.interactedBlockIds) {
            outputStream2.writeUTF(id.toString());
        }
    }

    @Override
    public void onDeserialize(DataInputStream inputStream2) throws IOException {
        int idsCount = inputStream2.readInt();
        this.interactedBlockIds.clear();
        for (int i = 0; i < idsCount; ++i) {
            UUID id = UUID.fromString(inputStream2.readUTF());
            this.interactedBlockIds.add(id);
        }
    }

    static {
        log = Log.getLogger(QuestBlockInteractObjectiveLifecycle.class.getName());
    }
}

