/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.lifecycle;

import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.quest.element.QuestConversationObjective;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionDefaultResponse;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionObjectiveCompleteResponse;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionProcessQueue;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionResponse;
import com.equestricraft.core.quest.element.conversation.QuestConversationElement;
import com.equestricraft.core.quest.element.conversation.lifecycle.NextElementResponse;
import com.equestricraft.core.quest.element.conversation.lifecycle.QuestConversationElementLifecycle;
import com.equestricraft.core.quest.element.lifecycle.QuestObjectiveElementLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class QuestConversationObjectiveLifecycle
extends QuestObjectiveElementLifecycle<QuestConversationObjective> {
    private static final QuestConversationActionProcessQueue questConversationActionProcessQueue = QuestConversationActionProcessQueue.getInstance();
    private QuestConversationElement currentConversationElement = null;
    private final AtomicBoolean preventManualAdvance = new AtomicBoolean(false);

    public QuestConversationObjectiveLifecycle(QuestConversationObjective element, QuestPlayer player) {
        super(element, player);
    }

    @Override
    void onObjectiveActivate() {
        if (((QuestConversationObjective)this.element).isPlayFirstElement()) {
            QuestConversationActionResponse response = this.advance();
            questConversationActionProcessQueue.queueAction(this.player, response);
        }
        this.updateCompass();
    }

    @Override
    void onResume() {
        if (this.currentConversationElement != null) {
            QuestConversationElementLifecycle<?> currentLifecycle = this.currentConversationElement.getLifecycle(this.player);
            currentLifecycle.resume();
        }
        this.updateCompass();
    }

    @Override
    void onDeactivate() {
        this.player.getCompassManager().removeCoordinates(((QuestConversationObjective)this.element).getId());
    }

    private void updateCompass() {
        if (((QuestConversationObjective)this.element).isShowOnCompass()) {
            DirectionalCoordinate npcLoc = ((QuestConversationObjective)this.getElement()).getNpc().getLocation();
            Coordinate loc = new Coordinate(npcLoc.x(), npcLoc.y(), npcLoc.z(), npcLoc.world());
            this.player.getCompassManager().addCoordinates(((QuestConversationObjective)this.element).getId(), loc);
        }
    }

    public void setCurrentConversationElement(QuestConversationElement currentConversationElement) {
        this.currentConversationElement = currentConversationElement;
    }

    public QuestConversationActionResponse advance() {
        return this.advance(null);
    }

    public QuestConversationActionResponse advance(Object promptInput) {
        if (this.preventManualAdvance.get()) {
            return new QuestConversationActionDefaultResponse((QuestConversationObjective)this.element);
        }
        NextElementResponse elementToPlayResponse = this.getElementToPlay(promptInput);
        if (elementToPlayResponse.previousElementFinished()) {
            QuestConversationElementLifecycle<?> lifecycle = this.currentConversationElement.getLifecycle(this.player);
            Optional<QuestConversationActionResponse> response = lifecycle.postProcess(promptInput);
            lifecycle.reset();
            if (response.isPresent()) {
                return response.get();
            }
        }
        if (elementToPlayResponse.conversationFinished()) {
            this.currentConversationElement = null;
            return new QuestConversationActionObjectiveCompleteResponse((QuestConversationObjective)this.element, elementToPlayResponse.output());
        }
        return elementToPlayResponse.nextElement().getLifecycle(this.player).process();
    }

    private NextElementResponse getElementToPlay(Object promptInput) {
        if (this.currentConversationElement == null) {
            QuestConversationElement firstElement = ((QuestConversationObjective)this.element).getFirstElement();
            return new NextElementResponse(firstElement, null, false);
        }
        return this.currentConversationElement.getLifecycle(this.player).getNextElement(promptInput);
    }

    public void setPreventManualAdvance(boolean prevent) {
        this.preventManualAdvance.set(prevent);
    }

    @Override
    void reset() {
        this.currentConversationElement = null;
    }

    @Override
    public void onSerialize(DataOutputStream outputStream2) throws IOException {
        if (this.currentConversationElement != null) {
            outputStream2.writeBoolean(true);
            outputStream2.writeUTF(this.currentConversationElement.getId().toString());
        } else {
            outputStream2.writeBoolean(false);
        }
        outputStream2.writeBoolean(this.preventManualAdvance.get());
    }

    @Override
    public void onDeserialize(DataInputStream inputStream2) throws IOException {
        boolean hasElement = inputStream2.readBoolean();
        if (hasElement) {
            UUID id = UUID.fromString(inputStream2.readUTF());
            this.currentConversationElement = ((QuestConversationObjective)this.getElement()).getElementById(id);
        } else {
            this.currentConversationElement = null;
        }
        this.preventManualAdvance.set(inputStream2.readBoolean());
    }
}

