/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.lifecycle;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.QuestElementOutputLinkInputType;
import com.equestricraft.common.QuestElementOutputType;
import com.equestricraft.core.quest.QuestPlaySession;
import com.equestricraft.core.quest.element.QuestElement;
import com.equestricraft.core.quest.element.QuestElementOutput;
import com.equestricraft.core.quest.element.QuestElementOutputLink;
import com.equestricraft.core.quest.element.lifecycle.QuestElementLifecycleStatus;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;

public abstract class QuestElementLifecycle<E extends QuestElement> {
    @Service
    static QuestPlaySession questPlaySession;
    final E element;
    final QuestPlayer player;
    private QuestElementLifecycleStatus status = QuestElementLifecycleStatus.NOT_ACTIVE;

    QuestElementLifecycle(E element, QuestPlayer player) {
        this.element = element;
        this.player = player;
    }

    public String getName() {
        return ((QuestElement)this.element).getName();
    }

    public final void activate() {
        this.player.getLifecycleManager().activate(this);
    }

    final void activateImpl() {
        this.reset();
        this.status = QuestElementLifecycleStatus.ACTIVE;
        this.onActivate();
    }

    void onActivate() {
    }

    public final void resume() {
        this.onResume();
    }

    void onResume() {
    }

    public final void deactivate() {
        this.player.getLifecycleManager().deactivate(this);
    }

    final void deactivateImpl() {
        this.status = QuestElementLifecycleStatus.DEACTIVATED;
        this.onDeactivate();
    }

    void onDeactivate() {
    }

    void reset() {
    }

    public void activateSuccessOutput() {
        this.activateElementOutput(QuestElementOutputType.SUCCESS);
    }

    public void activateFailureOutput() {
        this.activateElementOutput(QuestElementOutputType.FAILURE);
    }

    private void activateElementOutput(QuestElementOutputType type) {
        QuestElementOutput output = ((QuestElement)this.element).getOutputByType(type);
        this.activateOutput(output);
    }

    void activateElementOutput(String outputIdentifier) {
        QuestElementOutput output = ((QuestElement)this.element).getOutputByIdentifier(outputIdentifier);
        this.activateOutput(output);
    }

    public void activateOutput(QuestElementOutput output) {
        if (this.shouldDeactivateOnOutput()) {
            this.deactivate();
        }
        for (QuestElementOutputLink link : output.getLinks()) {
            QuestElementLifecycle<?> targetElementLifecycle = link.getTargetElement().getLifecycle(this.player);
            if (link.getInputType() == QuestElementOutputLinkInputType.ACTIVATE) {
                targetElementLifecycle.activate();
                continue;
            }
            if (link.getInputType() != QuestElementOutputLinkInputType.DEACTIVATE) continue;
            targetElementLifecycle.deactivate();
        }
        this.player.getLifecycleManager().process();
    }

    boolean shouldDeactivateOnOutput() {
        return true;
    }

    public final E getElement() {
        return this.element;
    }

    public final QuestElementLifecycleStatus getStatus() {
        return this.status;
    }

    public final boolean isActive() {
        return this.status == QuestElementLifecycleStatus.ACTIVE;
    }

    public boolean allowSaveWhenActive() {
        return true;
    }

    public boolean allowPauseWhenActive() {
        return true;
    }

    public final void serialize(DataOutputStream outputStream2) throws IOException {
        outputStream2.writeUTF(this.status.name());
        this.onSerialize(outputStream2);
    }

    void onSerialize(DataOutputStream outputStream2) throws IOException {
    }

    public final void deserialize(DataInputStream inputStream2) throws IOException {
        String statusName = inputStream2.readUTF();
        this.status = QuestElementLifecycleStatus.valueOf(statusName);
        this.onDeserialize(inputStream2);
    }

    void onDeserialize(DataInputStream inputStream2) throws IOException {
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuestElementLifecycle that = (QuestElementLifecycle)o;
        return Objects.equals(this.element, that.element);
    }

    public int hashCode() {
        return Objects.hashCode(this.element);
    }
}

