/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.lifecycle;

import com.equestricraft.common.QuestEndType;
import com.equestricraft.core.quest.QuestPlayersCache;
import com.equestricraft.core.quest.QuestStringInterpolator;
import com.equestricraft.core.quest.element.QuestEndElement;
import com.equestricraft.core.quest.element.lifecycle.QuestElementLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;

public class QuestEndElementLifecycle
extends QuestElementLifecycle<QuestEndElement> {
    private static final QuestPlayersCache questPlayersCache = QuestPlayersCache.getInstance();

    public QuestEndElementLifecycle(QuestEndElement element, QuestPlayer player) {
        super(element, player);
    }

    @Override
    void onActivate() {
        String endMessage;
        String string = endMessage = ((QuestEndElement)this.element).isShowEndTitle() && ((QuestEndElement)this.element).getEndMessage() != null && !((QuestEndElement)this.element).getEndMessage().isBlank() ? new QuestStringInterpolator(this.player).execute(((QuestEndElement)this.element).getEndMessage()) : null;
        if (((QuestEndElement)this.element).getEndType() == QuestEndType.SUCCESS) {
            questPlaySession.completeQuest(this.player, endMessage, ((QuestEndElement)this.element).getOutputId(), ((QuestEndElement)this.element).isShowEndTitle());
        } else if (((QuestEndElement)this.element).getEndType() == QuestEndType.FAILURE) {
            questPlaySession.failQuest(this.player, endMessage, ((QuestEndElement)this.element).getOutputId(), ((QuestEndElement)this.element).isShowEndTitle());
        } else {
            throw new IllegalArgumentException(String.format("Invalid end type: %s", ((QuestEndElement)this.element).getEndType().name()));
        }
        questPlayersCache.removePlayerFromPlayingQuest(((QuestEndElement)this.element).getQuest(), this.player);
    }
}

