/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.lifecycle;

import com.equestricraft.base.eventbus.ECEventBus;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.core.npc.NPCWaypointSetEvent;
import com.equestricraft.core.quest.QuestFollowObjectiveWaypoint;
import com.equestricraft.core.quest.QuestSettings;
import com.equestricraft.core.quest.element.QuestFollowNpcObjective;
import com.equestricraft.core.quest.element.lifecycle.QuestObjectiveElementLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import java.time.Duration;
import java.util.Optional;

public class QuestFollowNpcObjectiveLifecycle
extends QuestObjectiveElementLifecycle<QuestFollowNpcObjective> {
    public QuestFollowNpcObjectiveLifecycle(QuestFollowNpcObjective element, QuestPlayer player) {
        super(element, player);
    }

    @Override
    void onObjectiveActivate() {
        QuestFollowObjectiveWaypoint firstWaypoint = ((QuestFollowNpcObjective)this.element).getWaypoints().get(0);
        this.setWaypoint(firstWaypoint);
    }

    private void setWaypoint(QuestFollowObjectiveWaypoint waypoint) {
        Duration duration = Duration.ofSeconds(QuestSettings.getFollowNpcLimitBreachSeconds().intValue());
        NPCWaypointSetEvent event = NPCWaypointSetEvent.Builder.start(((QuestFollowNpcObjective)this.element).getNpc(), waypoint.getLocation()).withPlayer(this.player).withSpeed(waypoint.getSpeed() / 15.0).withMinimumDistance(((QuestFollowNpcObjective)this.element).getFollowMinimumDistance(), ((QuestFollowNpcObjective)this.element).getFollowTooCloseMessage() != null ? () -> TaskScheduler.executeAsyncTask(() -> this.player.sendMessage(((QuestFollowNpcObjective)this.element).getFollowTooCloseMessage())) : null, duration, () -> TaskScheduler.executeAsyncTask(this::activateFailureOutput)).withMaximumDistance(((QuestFollowNpcObjective)this.element).getFollowMaximumDistance(), ((QuestFollowNpcObjective)this.element).getFollowTooFarMessage() != null ? () -> TaskScheduler.executeAsyncTask(() -> this.player.sendMessage(((QuestFollowNpcObjective)this.element).getFollowTooFarMessage())) : null, duration, () -> TaskScheduler.executeAsyncTask(this::activateFailureOutput)).withOnReachAction(() -> this.processWaypointReach(waypoint)).complete();
        ECEventBus.post(event);
        if (((QuestFollowNpcObjective)this.element).isShowOnCompass()) {
            this.player.getCompassManager().removeCoordinates(((QuestFollowNpcObjective)this.element).getId());
            this.player.getCompassManager().addCoordinates(((QuestFollowNpcObjective)this.element).getId(), waypoint.getLocation());
        }
    }

    private void processWaypointReach(QuestFollowObjectiveWaypoint waypoint) {
        Optional<QuestFollowObjectiveWaypoint> nextWaypoint = ((QuestFollowNpcObjective)this.element).getWaypoints().stream().filter(w -> w.getOrder() > waypoint.getOrder()).findFirst();
        if (nextWaypoint.isPresent()) {
            this.setWaypoint(nextWaypoint.get());
        } else {
            this.activateSuccessOutput();
        }
    }

    @Override
    void onDeactivate() {
        this.player.getCompassManager().removeCoordinates(((QuestFollowNpcObjective)this.element).getId());
    }
}

