/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.quest.element.lifecycle;

import com.equestricraft.core.quest.QuestException;
import com.equestricraft.core.quest.element.QuestElement;
import com.equestricraft.core.quest.element.lifecycle.QuestElementLifecycle;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import com.equestricraft.logging.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class QuestLifecycleManager {
    private final List<QuestLifecycleAction> actions = new ArrayList<QuestLifecycleAction>();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final QuestPlayer player;
    private static final Log log = Log.getLogger(QuestLifecycleManager.class.getName());

    public QuestLifecycleManager(QuestPlayer player) {
        this.player = player;
    }

    public synchronized void activate(QuestElementLifecycle<?> questElementLifecycle) {
        ActivateAction action = new ActivateAction(questElementLifecycle);
        this.actions.add(action);
    }

    public synchronized void deactivate(QuestElementLifecycle<?> questElementLifecycle) {
        DeactivateAction action = new DeactivateAction(questElementLifecycle);
        this.actions.add(action);
    }

    public void process() {
        this.executorService.submit(this::processActions);
    }

    private void processActions() {
        List<QuestLifecycleAction> actionsToProcess = this.getActions();
        actionsToProcess.forEach(QuestLifecycleAction::execute);
        this.ensureQuestHasActiveElement(actionsToProcess);
        this.player.fireUpdate();
    }

    private synchronized List<QuestLifecycleAction> getActions() {
        ArrayList<QuestLifecycleAction> toProcess = new ArrayList<QuestLifecycleAction>(this.actions);
        this.actions.clear();
        return toProcess;
    }

    private void ensureQuestHasActiveElement(List<QuestLifecycleAction> processedActions) {
        if (this.player.hasTrackedQuest() && this.player.getTrackedQuestState().getActiveElementLifecycles().findAny().isEmpty()) {
            for (QuestLifecycleAction action : processedActions) {
                log.error("After processing {} the quest {} played by {} had no active elements", action, this.player.getTrackedQuest().getName(), this.player);
            }
            throw new QuestException("Quest has no active elements");
        }
    }

    public void shutdown() {
        try {
            boolean terminated = this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
            if (!terminated) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private static class ActivateAction
    extends QuestLifecycleAction {
        public ActivateAction(QuestElementLifecycle<?> lifecycle) {
            super(lifecycle);
        }

        @Override
        public void execute() {
            this.lifecycle.activateImpl();
        }

        @Override
        public String getActionDescription() {
            return "Activation of " + ((QuestElement)this.lifecycle.getElement()).getNameKey();
        }
    }

    private static class DeactivateAction
    extends QuestLifecycleAction {
        public DeactivateAction(QuestElementLifecycle<?> lifecycle) {
            super(lifecycle);
        }

        @Override
        public void execute() {
            this.lifecycle.deactivateImpl();
        }

        @Override
        public String getActionDescription() {
            return "Deactivation of " + ((QuestElement)this.lifecycle.getElement()).getNameKey();
        }
    }

    private static abstract class QuestLifecycleAction {
        final QuestElementLifecycle<?> lifecycle;

        public QuestLifecycleAction(QuestElementLifecycle<?> lifecycle) {
            this.lifecycle = lifecycle;
        }

        public abstract void execute();

        public abstract String getActionDescription();

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QuestLifecycleAction that = (QuestLifecycleAction)o;
            return Objects.equals(this.lifecycle, that.lifecycle);
        }

        public int hashCode() {
            return Objects.hashCode(this.lifecycle);
        }

        public String toString() {
            return this.getActionDescription();
        }
    }
}

